/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import io.github.crow_misia.libyuv.AbstractBuffer;
import io.github.crow_misia.libyuv.ArgbBuffer;
import io.github.crow_misia.libyuv.BufferExtKt;
import io.github.crow_misia.libyuv.BufferFactory;
import io.github.crow_misia.libyuv.BufferFirstAlpha;
import io.github.crow_misia.libyuv.BufferX400;
import io.github.crow_misia.libyuv.BufferX420;
import io.github.crow_misia.libyuv.BufferY;
import io.github.crow_misia.libyuv.FilterMode;
import io.github.crow_misia.libyuv.I420Buffer;
import io.github.crow_misia.libyuv.Nv12Buffer;
import io.github.crow_misia.libyuv.Nv21Buffer;
import io.github.crow_misia.libyuv.Plane;
import io.github.crow_misia.libyuv.PlanePrimitive;
import io.github.crow_misia.libyuv.RotateMode;
import io.github.crow_misia.libyuv.Yuv;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001\u001cB3\b\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\nR\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/github/crow_misia/libyuv/I400Buffer;", "Lio/github/crow_misia/libyuv/AbstractBuffer;", "Lio/github/crow_misia/libyuv/BufferX400;", "Lio/github/crow_misia/libyuv/I420Buffer;", "Lio/github/crow_misia/libyuv/BufferY;", "buffer", "Ljava/nio/ByteBuffer;", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "width", "", "height", "releaseCallback", "Ljava/lang/Runnable;", "(Ljava/nio/ByteBuffer;Lio/github/crow_misia/libyuv/Plane;IILjava/lang/Runnable;)V", "getHeight", "()I", "getPlaneY", "()Lio/github/crow_misia/libyuv/Plane;", "getWidth", "convertTo", "", "dst", "Lio/github/crow_misia/libyuv/ArgbBuffer;", "Lio/github/crow_misia/libyuv/Nv12Buffer;", "Lio/github/crow_misia/libyuv/Nv21Buffer;", "setValue", "value", "Factory", "libyuv-android"})
public final class I400Buffer
extends AbstractBuffer
implements BufferX400<I400Buffer, I420Buffer>,
BufferY<I400Buffer> {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final Plane planeY;
    private final int width;
    private final int height;

    private I400Buffer(ByteBuffer buffer, Plane planeY, int width, int height, Runnable releaseCallback) {
        Plane[] planeArray = new Plane[]{planeY};
        super(buffer, planeArray, releaseCallback);
        this.planeY = planeY;
        this.width = width;
        this.height = height;
    }

    @Override
    @NotNull
    public Plane getPlaneY() {
        return this.planeY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public final void convertTo(@NotNull Nv21Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertI400ToNV21(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneVU().getBuffer(), dst.getPlaneVU().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull Nv12Buffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertI400ToNV21(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), dst.getPlaneY().getBuffer(), dst.getPlaneY().getRowStride(), dst.getPlaneUV().getBuffer(), dst.getPlaneUV().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    @Override
    public final void convertTo(@NotNull ArgbBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Yuv.INSTANCE.convertI400ToARGB(this.getPlaneY().getBuffer(), this.getPlaneY().getRowStride(), dst.getPlane().getBuffer(), dst.getPlane().getRowStride(), Math.min(this.getWidth(), dst.getWidth()), Math.min(this.getHeight(), dst.getHeight()));
    }

    public final void setValue(int value) {
        this.getPlaneY().setValue(this.getWidth(), this.getHeight(), value);
    }

    @Override
    public void convertTo(@NotNull I420Buffer dst) {
        BufferX400.DefaultImpls.convertTo(this, (BufferX420)dst);
    }

    @Override
    public void convertTo(@NotNull I400Buffer dst) {
        BufferX400.DefaultImpls.convertTo(this, (BufferX400)dst);
    }

    @Override
    public void mirrorTo(@NotNull I400Buffer dst) {
        BufferX400.DefaultImpls.mirrorTo(this, (BufferX400)dst);
    }

    @Override
    public void rotate(@NotNull I400Buffer dst, @NotNull RotateMode rotateMode) {
        BufferX400.DefaultImpls.rotate(this, (BufferX400)dst, rotateMode);
    }

    @Override
    public void scale(@NotNull I400Buffer dst, @NotNull FilterMode filterMode) {
        BufferX400.DefaultImpls.scale(this, (BufferX400)dst, filterMode);
    }

    @Override
    public void copyAlpha(@NotNull BufferFirstAlpha dst) {
        BufferX400.DefaultImpls.copyAlpha(this, dst);
    }

    public /* synthetic */ I400Buffer(ByteBuffer buffer, Plane planeY, int width, int height, Runnable releaseCallback, DefaultConstructorMarker $constructor_marker) {
        this(buffer, planeY, width, height, releaseCallback);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J \u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lio/github/crow_misia/libyuv/I400Buffer$Factory;", "Lio/github/crow_misia/libyuv/BufferFactory;", "Lio/github/crow_misia/libyuv/I400Buffer;", "()V", "allocate", "width", "", "height", "getStrideWithCapacity", "", "wrap", "planeY", "Lio/github/crow_misia/libyuv/Plane;", "buffer", "Ljava/nio/ByteBuffer;", "libyuv-android"})
    @SourceDebugExtension(value={"SMAP\nI400Buffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 I400Buffer.kt\nio/github/crow_misia/libyuv/I400Buffer$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
    public static final class Factory
    implements BufferFactory<I400Buffer> {
        private Factory() {
        }

        private final int[] getStrideWithCapacity(int width, int height) {
            int[] nArray = new int[]{width, width * height};
            return nArray;
        }

        @Override
        @NotNull
        public I400Buffer allocate(int width, int height) {
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacity = nArray[1];
            ByteBuffer bufferY = BufferExtKt.createByteBuffer(capacity);
            return new I400Buffer(bufferY, new PlanePrimitive(strideY, bufferY), width, height, () -> Factory.allocate$lambda$0(bufferY), null);
        }

        @Override
        @NotNull
        public I400Buffer wrap(@NotNull ByteBuffer buffer, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!buffer.isDirect()) {
                boolean $i$a$-check-I400Buffer$Factory$wrap$22 = false;
                String $i$a$-check-I400Buffer$Factory$wrap$22 = "Unsupported non-direct ByteBuffer.";
                throw new IllegalStateException($i$a$-check-I400Buffer$Factory$wrap$22.toString());
            }
            int[] nArray = this.getStrideWithCapacity(width, height);
            int strideY = nArray[0];
            int capacity = nArray[1];
            ByteBuffer bufferY = BufferExtKt.sliceRange(buffer, 0, capacity);
            return new I400Buffer(bufferY, new PlanePrimitive(strideY, bufferY), width, height, null, null);
        }

        @NotNull
        public final I400Buffer wrap(@NotNull Plane planeY, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)planeY, (String)"planeY");
            return new I400Buffer(planeY.getBuffer(), planeY, width, height, null, null);
        }

        private static final void allocate$lambda$0(ByteBuffer $bufferY) {
            Intrinsics.checkNotNullParameter((Object)$bufferY, (String)"$bufferY");
            Yuv.INSTANCE.freeNativeBuffer($bufferY);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

