/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.task;

import io.github.crimix.changedprojectstask.configuration.ChangedProjectsChoice;
import io.github.crimix.changedprojectstask.configuration.ChangedProjectsConfiguration;
import io.github.crimix.changedprojectstask.extensions.Extensions;
import io.github.crimix.changedprojectstask.providers.ChangedFilesProvider;
import io.github.crimix.changedprojectstask.providers.ProjectDependencyProvider;
import io.github.crimix.changedprojectstask.utils.LoggingOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;

public class ChangedProjectsTask {
    private final Project project;
    private final Task task;
    private final ChangedProjectsConfiguration extension;
    private boolean affectsAll = false;
    private Set<Project> affectedProjects = new HashSet<Project>();
    private Set<Project> alwaysRunProjects = new HashSet<Project>();
    private Set<Project> neverRunProjects = new HashSet<Project>();

    private ChangedProjectsTask(Project project, Task task, ChangedProjectsConfiguration extension) {
        this.project = project;
        this.task = task;
        this.extension = extension;
    }

    public static void configureAndRun(Project project, Task task, ChangedProjectsConfiguration extension) {
        ChangedProjectsTask changedProjectsTask = new ChangedProjectsTask(project, task, extension);
        if (!Extensions.shouldUseCommandLine(project)) {
            changedProjectsTask.configureBeforeEvaluate();
        }
        project.getGradle().projectsEvaluated(g -> changedProjectsTask.afterEvaluate());
    }

    private void configureBeforeEvaluate() {
        for (Project project : this.project.getAllprojects()) {
            this.configureProject(project);
        }
    }

    private void afterEvaluate() {
        this.configureAfterAllEvaluate();
        if (Extensions.shouldUseCommandLine(this.project)) {
            this.commandLineRunProjects();
        }
    }

    private void commandLineRunProjects() {
        for (Project project : this.project.getAllprojects()) {
            if (!this.shouldProjectRun(project)) continue;
            this.runCommandLineOnProject(project);
        }
    }

    private void configureProject(Project project) {
        project.afterEvaluate(p -> {
            String path = this.getPathToTask((Project)p);
            this.task.dependsOn(new Object[]{path});
            Task otherTask = p.getTasks().findByPath(path);
            if (otherTask != null) {
                otherTask.onlyIf(t -> this.shouldProjectRun((Project)p));
            }
        });
    }

    private boolean shouldProjectRun(Project p) {
        return !this.neverRunProjects.contains(p) && (this.affectsAll || this.affectedProjects.contains(p) || this.alwaysRunProjects.contains(p));
    }

    private void configureAfterAllEvaluate() {
        Extensions.validate(this.extension, this.project);
        if (this.hasBeenEnabled()) {
            Extensions.print(this.extension, this.project, this.getLogger());
            Project project = this.getRootProject();
            ChangedFilesProvider changedFilesProvider = new ChangedFilesProvider(project, this.extension);
            changedFilesProvider.printDebug(this.getLogger());
            if (changedFilesProvider.getChangedFiles().isEmpty() && !changedFilesProvider.isAllProjectsAffected()) {
                return;
            }
            this.configureAlwaysAndNeverRun(project);
            if (changedFilesProvider.isAllProjectsAffected()) {
                this.affectsAll = true;
            } else {
                ProjectDependencyProvider projectDependencyProvider = new ProjectDependencyProvider(project, this.extension);
                projectDependencyProvider.printDebug(this.getLogger());
                Set<Project> directlyAffectedProjects = this.evaluateDirectAffectedProjects(changedFilesProvider, projectDependencyProvider);
                if (Extensions.shouldLog(this.extension)) {
                    this.getLogger().lifecycle("Directly affected projects: {}", new Object[]{directlyAffectedProjects});
                }
                HashSet<Project> dependentAffectedProjects = new HashSet<Project>();
                if (ChangedProjectsChoice.INCLUDE_DEPENDENTS == Extensions.getPluginMode(this.extension)) {
                    dependentAffectedProjects.addAll(projectDependencyProvider.getAffectedDependentProjects(directlyAffectedProjects));
                    if (Extensions.shouldLog(this.extension)) {
                        this.getLogger().lifecycle("Dependent affected Projects: {}", new Object[]{dependentAffectedProjects});
                    }
                }
                this.affectedProjects = Stream.concat(directlyAffectedProjects.stream(), dependentAffectedProjects.stream()).collect(Collectors.toSet());
            }
        }
    }

    private void runCommandLineOnProject(Project affected) {
        String commandLine = String.format("%s %s %s", this.getGradleWrapper(), this.getPathToTask(affected), Extensions.getCommandLineArgs(this.project));
        if (Extensions.shouldLog(this.extension)) {
            this.getLogger().lifecycle("Running {}", new Object[]{commandLine});
        }
        LoggingOutputStream stdout = new LoggingOutputStream(arg_0 -> ((Logger)this.project.getLogger()).lifecycle(arg_0));
        LoggingOutputStream stderr = new LoggingOutputStream(arg_0 -> ((Logger)this.project.getLogger()).error(arg_0));
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr)));
        exec.setWorkingDirectory(this.project.getRootProject().getProjectDir());
        int exitValue = exec.execute(CommandLine.parse((String)commandLine));
        if (exitValue != 0) {
            throw new IllegalStateException("Executing command failed");
        }
    }

    private String getGradleWrapper() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return "gradlew.bat";
        }
        return "./gradlew";
    }

    private Set<Project> evaluateDirectAffectedProjects(ChangedFilesProvider changedFilesProvider, ProjectDependencyProvider projectDependencyProvider) {
        return changedFilesProvider.getChangedFiles().stream().map(projectDependencyProvider::getChangedProject).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void configureAlwaysAndNeverRun(Project project) {
        Set alwaysRunPath = (Set)this.extension.getAlwaysRunProject().getOrElse(Collections.emptySet());
        this.alwaysRunProjects = project.getAllprojects().stream().filter(p -> alwaysRunPath.contains(p.getPath())).collect(Collectors.toSet());
        if (Extensions.shouldLog(this.extension)) {
            this.getLogger().lifecycle("Always run projects: {}", new Object[]{this.alwaysRunProjects});
        }
        Set neverRunPath = (Set)this.extension.getNeverRunProject().getOrElse(Collections.emptySet());
        this.neverRunProjects = project.getAllprojects().stream().filter(p -> neverRunPath.contains(p.getPath())).collect(Collectors.toSet());
        if (Extensions.shouldLog(this.extension)) {
            this.getLogger().lifecycle("Never run projects: {}", new Object[]{this.neverRunProjects});
        }
    }

    private Project getRootProject() {
        return this.project.getRootProject();
    }

    private boolean hasBeenEnabled() {
        return Extensions.hasBeenEnabled(this.project);
    }

    private Logger getLogger() {
        return this.project.getLogger();
    }

    private String getPathToTask(Project project) {
        String taskToRun = Extensions.getTaskToRun(project, this.extension);
        if (Extensions.isRootProject(project)) {
            return String.format(":%s", taskToRun);
        }
        return String.format("%s:%s", project.getPath(), taskToRun);
    }
}

