/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask;

import io.github.crimix.changedprojectstask.configuration.ChangedProjectsConfiguration;
import io.github.crimix.changedprojectstask.extensions.Extensions;
import io.github.crimix.changedprojectstask.task.ChangedProjectsTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class ChangedProjectsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (!Extensions.isRootProject(project)) {
            throw new IllegalArgumentException(String.format("Must be applied to root project %s, but was found on %s instead.", project.getRootProject(), project.getName()));
        }
        ChangedProjectsConfiguration extension = (ChangedProjectsConfiguration)project.getExtensions().create("changedProjectsTask", ChangedProjectsConfiguration.class, new Object[0]);
        Task task = (Task)project.getTasks().register("runTaskForChangedProjects").get();
        if (Extensions.hasBothRunCommands(project)) {
            throw new IllegalArgumentException("You may either use run or runCommandLine, not both");
        }
        if (Extensions.hasBeenEnabled(project)) {
            ChangedProjectsTask.configureAndRun(project, task, extension);
        }
    }
}

