/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.InvocationRequest;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.crac.Context;
import org.crac.Core;
import org.crac.Resource;

class NativeClient {
    private static final String nativeLibPath = "/tmp/.aws-lambda-runtime-interface-client";
    private static final String[] libsToTry;
    private static final Throwable[] exceptions;
    static CheckpointState checkpointState;

    NativeClient() {
    }

    private static void initializeNativeClient() {
        String userAgent = String.format("aws-lambda-java/%s-%s", System.getProperty("java.vendor.version"), NativeClient.class.getPackage().getImplementationVersion());
        NativeClient.initializeClient(userAgent.getBytes());
    }

    static native void initializeClient(byte[] var0);

    private static native InvocationRequest next();

    static InvocationRequest nextWrapper() {
        return NativeClient.next();
    }

    private static native void postInvocationResponse(byte[] var0, byte[] var1);

    static void postInvocationResponseWrapper(byte[] requestId, byte[] response) {
        NativeClient.postInvocationResponse(requestId, response);
        checkpointState.syncPoint();
    }

    static native void deinitializeClient();

    static {
        int i;
        libsToTry = new String[]{"aws-lambda-runtime-interface-client.glibc.so", "aws-lambda-runtime-interface-client.musl.so"};
        exceptions = new Throwable[libsToTry.length];
        checkpointState = new CheckpointState();
        boolean loaded = false;
        String basestr = System.getProperty("com.amazonaws.services.lambda.runtime.api.client.NativeClient.libsBase", "/");
        Path base = Paths.get(basestr, new String[0]);
        for (i = 0; !loaded && i < libsToTry.length; ++i) {
            Path p = base.resolve(libsToTry[i]);
            if (Files.exists(p, new LinkOption[0])) {
                try {
                    System.load(p.toString());
                    loaded = true;
                }
                catch (UnsatisfiedLinkError e) {
                    NativeClient.exceptions[i] = e;
                }
                catch (Exception e) {
                    NativeClient.exceptions[i] = e;
                }
            }
            if (loaded || exceptions[i] != null) continue;
            try (InputStream lib = NativeClient.class.getResourceAsStream("/" + libsToTry[i]);){
                Files.copy(lib, Paths.get(nativeLibPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                System.load(nativeLibPath);
                loaded = true;
                continue;
            }
            catch (UnsatisfiedLinkError e) {
                NativeClient.exceptions[i] = e;
                continue;
            }
            catch (Exception e) {
                NativeClient.exceptions[i] = e;
            }
        }
        if (!loaded) {
            for (i = 0; i < libsToTry.length; ++i) {
                System.err.print(exceptions[i]);
                System.err.printf("Failed to load the native runtime interface client library %s. Exception: %s\n", libsToTry[i], exceptions[i].getMessage());
            }
            System.exit(-1);
        }
        NativeClient.initializeNativeClient();
        Core.getGlobalContext().register((Resource)checkpointState);
    }

    static class CheckpointState
    implements Resource {
        State state = State.WORKING;

        CheckpointState() {
        }

        private void waitFor(State targetState) {
            while (this.state != targetState) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
            this.state = State.SYNCING;
            this.waitFor(State.SYNCED);
            NativeClient.deinitializeClient();
        }

        public synchronized void afterRestore(Context<? extends Resource> context) throws Exception {
            NativeClient.initializeNativeClient();
            this.state = State.WORKING;
            this.notifyAll();
        }

        public synchronized void syncPoint() {
            if (this.state == State.SYNCING) {
                this.state = State.SYNCED;
                this.notifyAll();
            }
            this.waitFor(State.WORKING);
        }

        static enum State {
            WORKING,
            SYNCING,
            SYNCED;

        }
    }
}

