/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.runtimeapi;

import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.InvocationRequest;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeClientException;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.NativeClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class LambdaRuntimeClient {
    private final String hostname;
    private final int port;
    private final String invocationEndpoint;
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String XRAY_ERROR_CAUSE_HEADER = "Lambda-Runtime-Function-XRay-Error-Cause";
    private static final String ERROR_TYPE_HEADER = "Lambda-Runtime-Function-Error-Type";
    private static final int XRAY_ERROR_CAUSE_MAX_HEADER_SIZE = 0x100000;

    public LambdaRuntimeClient(String hostnamePort) {
        Objects.requireNonNull(hostnamePort, "hostnamePort cannot be null");
        String[] parts = hostnamePort.split(":");
        this.hostname = parts[0];
        this.port = Integer.parseInt(parts[1]);
        this.invocationEndpoint = this.invocationEndpoint();
    }

    public InvocationRequest waitForNextInvocation() {
        return NativeClient.nextWrapper();
    }

    public void postInvocationResponse(String requestId, byte[] response) {
        NativeClient.postInvocationResponseWrapper(requestId.getBytes(StandardCharsets.UTF_8), response);
    }

    public void postInvocationError(String requestId, byte[] errorResponse, String errorType) throws IOException {
        this.postInvocationError(requestId, errorResponse, errorType, null);
    }

    public void postInvocationError(String requestId, byte[] errorResponse, String errorType, String errorCause) throws IOException {
        String endpoint = this.invocationErrorEndpoint(requestId);
        this.post(endpoint, errorResponse, errorType, errorCause);
    }

    public void postInitError(byte[] errorResponse, String errorType) throws IOException {
        String endpoint = this.initErrorEndpoint();
        this.post(endpoint, errorResponse, errorType, null);
    }

    private void post(String endpoint, byte[] errorResponse, String errorType, String errorCause) throws IOException {
        URL url = this.createUrl(endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", DEFAULT_CONTENT_TYPE);
        if (errorType != null && !errorType.isEmpty()) {
            conn.setRequestProperty(ERROR_TYPE_HEADER, errorType);
        }
        if (errorCause != null && errorCause.getBytes().length < 0x100000) {
            conn.setRequestProperty(XRAY_ERROR_CAUSE_HEADER, errorCause);
        }
        conn.setFixedLengthStreamingMode(errorResponse.length);
        conn.setDoOutput(true);
        try (OutputStream outputStream = conn.getOutputStream();){
            outputStream.write(errorResponse);
        }
        int responseCode = conn.getResponseCode();
        if (responseCode != 202) {
            throw new LambdaRuntimeClientException(endpoint, responseCode);
        }
        this.closeQuietly(conn.getInputStream());
    }

    private String invocationEndpoint() {
        return "http://" + this.hostname + ":" + this.port + "/2018-06-01/runtime/invocation/";
    }

    private String invocationErrorEndpoint(String requestId) {
        return this.invocationEndpoint + requestId + "/error";
    }

    private String initErrorEndpoint() {
        return "http://" + this.hostname + ":" + this.port + "/2018-06-01/runtime/init/error";
    }

    private URL createUrl(String endpoint) {
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

