/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.api.client.CustomerClassLoader;
import com.amazonaws.services.lambda.runtime.api.client.EventHandlerLoader;
import com.amazonaws.services.lambda.runtime.api.client.Failure;
import com.amazonaws.services.lambda.runtime.api.client.HandlerInfo;
import com.amazonaws.services.lambda.runtime.api.client.LambdaRequestHandler;
import com.amazonaws.services.lambda.runtime.api.client.UserFault;
import com.amazonaws.services.lambda.runtime.api.client.UserMethods;
import com.amazonaws.services.lambda.runtime.api.client.XRayErrorCause;
import com.amazonaws.services.lambda.runtime.api.client.logging.FramedTelemetryLogSink;
import com.amazonaws.services.lambda.runtime.api.client.logging.LambdaContextLogger;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import com.amazonaws.services.lambda.runtime.api.client.logging.StdOutLogSink;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.InvocationRequest;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeClient;
import com.amazonaws.services.lambda.runtime.api.client.util.EnvReader;
import com.amazonaws.services.lambda.runtime.api.client.util.EnvWriter;
import com.amazonaws.services.lambda.runtime.api.client.util.LambdaOutputStream;
import com.amazonaws.services.lambda.runtime.api.client.util.UnsafeUtil;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.factories.GsonFactory;
import com.amazonaws.services.lambda.runtime.serialization.factories.JacksonFactory;
import com.amazonaws.services.lambda.runtime.serialization.util.ReflectUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.Security;
import java.util.Properties;

public class AWSLambda {
    private static final Runnable doNothing;
    private static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String JAVA_SECURITY_PROPERTIES = "java.security.properties";
    private static final String NETWORKADDRESS_CACHE_NEGATIVE_TTL_ENV_VAR = "AWS_LAMBDA_JAVA_NETWORKADDRESS_CACHE_NEGATIVE_TTL";
    private static final String NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY = "networkaddress.cache.negative.ttl";
    private static final String DEFAULT_NEGATIVE_CACHE_TTL = "1";
    protected static URLClassLoader customerClassLoader;
    private static PojoSerializer<XRayErrorCause> xRayErrorCauseSerializer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNegativeCacheOverridable() {
        String securityPropertiesPath = System.getProperty(JAVA_SECURITY_PROPERTIES);
        if (securityPropertiesPath == null) {
            return true;
        }
        try (FileInputStream inputStream = new FileInputStream(securityPropertiesPath);){
            Properties secProps = new Properties();
            secProps.load(inputStream);
            boolean bl = !secProps.containsKey(NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY);
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static UserMethods findUserMethods(String handlerString, ClassLoader customerClassLoader) {
        HandlerInfo handlerInfo;
        try {
            handlerInfo = HandlerInfo.fromString(handlerString, customerClassLoader);
        }
        catch (HandlerInfo.InvalidHandlerException e) {
            UserFault userFault = UserFault.makeUserFault("Invalid handler: `" + handlerString + "'");
            return new UserMethods(doNothing, new LambdaRequestHandler.UserFaultHandler(userFault));
        }
        catch (ClassNotFoundException e) {
            return new UserMethods(doNothing, LambdaRequestHandler.classNotFound(e, HandlerInfo.className(handlerString)));
        }
        catch (NoClassDefFoundError e) {
            return new UserMethods(doNothing, LambdaRequestHandler.initErrorHandler(e, HandlerInfo.className(handlerString)));
        }
        catch (Throwable t) {
            throw UserFault.makeInitErrorUserFault(t, HandlerInfo.className(handlerString));
        }
        LambdaRequestHandler requestHandler = EventHandlerLoader.loadEventHandler(handlerInfo);
        if (requestHandler instanceof LambdaRequestHandler.UserFaultHandler) {
            UserFault userFault = ((LambdaRequestHandler.UserFaultHandler)requestHandler).fault;
            if (userFault.fatal.booleanValue()) {
                throw userFault;
            }
        }
        Runnable initHandler = doNothing;
        try {
            initHandler = AWSLambda.wrapInitCall(handlerInfo.clazz.getMethod("init", new Class[0]));
        }
        catch (NoClassDefFoundError | NoSuchMethodException throwable) {
            // empty catch block
        }
        return new UserMethods(initHandler, requestHandler);
    }

    private static Runnable wrapInitCall(Method method) {
        return () -> {
            try {
                method.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                throw UserFault.makeUserFault(t);
            }
        };
    }

    public static void setupRuntimeLogger(LambdaLogger lambdaLogger) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        ReflectUtil.setStaticField(Class.forName("com.amazonaws.services.lambda.runtime.LambdaRuntime"), (String)"logger", (boolean)true, (Object)lambdaLogger);
    }

    public static String getEnvOrExit(String envVariableName) {
        String value = System.getenv(envVariableName);
        if (value == null) {
            System.err.println("Could not get environment variable " + envVariableName);
            System.exit(-1);
        }
        return value;
    }

    private static LogSink createLogSink() {
        String fd = System.getenv("_LAMBDA_TELEMETRY_LOG_FD");
        if (fd == null) {
            return new StdOutLogSink();
        }
        try {
            File pipeFdFile = Paths.get("/proc", "self", "fd", fd).toFile();
            return new FramedTelemetryLogSink(pipeFdFile);
        }
        catch (IOException e) {
            return new StdOutLogSink();
        }
    }

    public static void main(String[] args) {
        AWSLambda.startRuntime(args[0]);
    }

    private static void startRuntime(String handler) {
        try (LogSink logSink = AWSLambda.createLogSink();){
            AWSLambda.startRuntime(handler, new LambdaContextLogger(logSink));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startRuntime(String handler, LambdaLogger lambdaLogger) throws Throwable {
        UserMethods methods;
        UnsafeUtil.disableIllegalAccessWarning();
        System.setOut(new PrintStream((OutputStream)new LambdaOutputStream(System.out), false, "UTF-8"));
        System.setErr(new PrintStream((OutputStream)new LambdaOutputStream(System.err), false, "UTF-8"));
        AWSLambda.setupRuntimeLogger(lambdaLogger);
        String runtimeApi = AWSLambda.getEnvOrExit("AWS_LAMBDA_RUNTIME_API");
        LambdaRuntimeClient runtimeClient = new LambdaRuntimeClient(runtimeApi);
        EnvReader envReader = new EnvReader();
        try (EnvWriter envWriter = new EnvWriter(envReader);){
            envWriter.unsetLambdaInternalEnv();
            envWriter.setupEnvironmentCredentials();
            envWriter.setupAwsExecutionEnv();
        }
        String taskRoot = System.getProperty("user.dir");
        String libRoot = "/opt/java";
        customerClassLoader = new CustomerClassLoader(taskRoot, libRoot, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(customerClassLoader);
        try {
            methods = AWSLambda.findUserMethods(handler, customerClassLoader);
        }
        catch (UserFault userFault) {
            lambdaLogger.log(userFault.reportableError());
            ByteArrayOutputStream payload = new ByteArrayOutputStream(1024);
            Failure failure = new Failure(userFault);
            GsonFactory.getInstance().getSerializer(Failure.class).toJson((Object)failure, (OutputStream)payload);
            runtimeClient.postInitError(payload.toByteArray(), failure.getErrorType());
            System.exit(1);
            return;
        }
        try {
            methods.initHandler.run();
        }
        catch (UserFault f) {
            lambdaLogger.log(f.reportableError());
        }
        try (EnvWriter envWriter = new EnvWriter(envReader);){
            boolean shouldExit = false;
            while (!shouldExit) {
                Failure failure;
                ByteArrayOutputStream payload;
                UserFault userFault = null;
                InvocationRequest request = runtimeClient.waitForNextInvocation();
                if (request.getXrayTraceId() != null) {
                    envWriter.modifyEnv(m -> m.put("_X_AMZN_TRACE_ID", request.getXrayTraceId()));
                } else {
                    envWriter.modifyEnv(m -> {
                        String cfr_ignored_0 = (String)m.remove("_X_AMZN_TRACE_ID");
                    });
                }
                try {
                    payload = methods.requestHandler.call(request);
                    runtimeClient.postInvocationResponse(request.getId(), payload.toByteArray());
                }
                catch (UserFault f) {
                    userFault = f;
                    UserFault.filterStackTrace(f);
                    payload = new ByteArrayOutputStream(1024);
                    failure = new Failure(f);
                    GsonFactory.getInstance().getSerializer(Failure.class).toJson((Object)failure, (OutputStream)payload);
                    shouldExit = f.fatal;
                    runtimeClient.postInvocationError(request.getId(), payload.toByteArray(), failure.getErrorType());
                }
                catch (Throwable t) {
                    UserFault.filterStackTrace(t);
                    userFault = UserFault.makeUserFault(t);
                    payload = new ByteArrayOutputStream(1024);
                    failure = new Failure(t);
                    GsonFactory.getInstance().getSerializer(Failure.class).toJson((Object)failure, (OutputStream)payload);
                    shouldExit = Failure.isInvokeFailureFatal(t);
                    runtimeClient.postInvocationError(request.getId(), payload.toByteArray(), failure.getErrorType(), AWSLambda.serializeAsXRayJson(t));
                }
                finally {
                    if (userFault == null) continue;
                    lambdaLogger.log(userFault.reportableError());
                }
            }
        }
    }

    private static String serializeAsXRayJson(Throwable throwable) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XRayErrorCause cause = new XRayErrorCause(throwable);
            if (xRayErrorCauseSerializer == null) {
                xRayErrorCauseSerializer = JacksonFactory.getInstance().getSerializer(XRayErrorCause.class);
            }
            xRayErrorCauseSerializer.toJson((Object)cause, (OutputStream)outputStream);
            return ((Object)outputStream).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        File systemCacerts;
        doNothing = () -> {};
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, MD5withRSA, DH keySize < 1024, EC keySize < 224, DES40_CBC, RC4_40, 3DES_EDE_CBC");
        if (System.getProperty(TRUST_STORE_PROPERTY) == null && (systemCacerts = new File("/etc/pki/java/cacerts")).exists() && systemCacerts.isFile()) {
            System.setProperty(TRUST_STORE_PROPERTY, systemCacerts.getPath());
        }
        if (AWSLambda.isNegativeCacheOverridable()) {
            String ttlFromEnv = System.getenv(NETWORKADDRESS_CACHE_NEGATIVE_TTL_ENV_VAR);
            String negativeCacheTtl = ttlFromEnv == null ? DEFAULT_NEGATIVE_CACHE_TTL : ttlFromEnv;
            Security.setProperty(NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY, negativeCacheTtl);
        }
    }
}

