package io.github.cdimascio.dotenv


fun main(args: Array<String>) {
    val multilineString = "1\n2"

    val d = Dotenv.configure().ignoreIfMalformed().load()
    val multilineFromDotEnv = d["MULTI_LINE"]
    val multilineFromSystemEnv = System.getenv("MULTI_LINE")

    println("Characters from multiline")
    printChars(multilineString)
    println("\n\nCharacters from dotenv")
    printChars(multilineFromDotEnv!!)

    println("\n\nPrinted string with multiline")
    println(multilineString)

    println("Printed string from dotenv")
    println(multilineFromDotEnv)

    println("Printed string from system")
    println(multilineFromSystemEnv)

    println("\n\nAre system env and dotenv equal? : " + (multilineFromSystemEnv == multilineFromDotEnv))
    println("\n\nAre system and multilineString equal? : " + (multilineString == multilineFromSystemEnv))
    println("\n\nAre dotenv and multilineString equal? : " + (multilineString == multilineFromDotEnv))
}

private fun printChars(all: String) {
    all.chars().forEach { println(it) }
}
