/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.cookiejar.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import okhttp3.Cookie;

class IdentifiableCookie {
    private Cookie cookie;

    static List<IdentifiableCookie> decorateAll(Collection<Cookie> cookies) {
        ArrayList<IdentifiableCookie> identifiableCookies = new ArrayList<IdentifiableCookie>(cookies.size());
        for (Cookie cookie : cookies) {
            identifiableCookies.add(new IdentifiableCookie(cookie));
        }
        return identifiableCookies;
    }

    IdentifiableCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    Cookie getCookie() {
        return this.cookie;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IdentifiableCookie)) {
            return false;
        }
        IdentifiableCookie that = (IdentifiableCookie)other;
        return that.cookie.name().equals(this.cookie.name()) && that.cookie.domain().equals(this.cookie.domain()) && that.cookie.path().equals(this.cookie.path()) && that.cookie.secure() == this.cookie.secure() && that.cookie.hostOnly() == this.cookie.hostOnly();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.cookie.name().hashCode();
        hash = 31 * hash + this.cookie.domain().hashCode();
        hash = 31 * hash + this.cookie.path().hashCode();
        hash = 31 * hash + (this.cookie.secure() ? 0 : 1);
        hash = 31 * hash + (this.cookie.hostOnly() ? 0 : 1);
        return hash;
    }
}

