/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.webview;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.KeyEvent;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import kr.co.bootpay.android.webview.BootpayUrlHelper;
import kr.co.bootpay.android.webview.BootpayWebView;

public class BootpayWebViewClient
extends WebViewClient {
    @Nullable
    protected String ignoreErrFailedForThisURL = null;

    public void setIgnoreErrFailedForThisURL(@Nullable String url) {
        this.ignoreErrFailedForThisURL = url;
    }

    public void onPageFinished(WebView webView, String url) {
        super.onPageFinished(webView, url);
        this.updateBlindViewIfNaverLogin(webView, url);
        if (url.contains("webview.bootpay.co.kr")) {
            BootpayWebView _webView = (BootpayWebView)webView;
            _webView.callInjectedJavaScriptBeforePayStart();
            _webView.callInjectedJavaScript();
        }
    }

    private void updateBlindViewIfNaverLogin(WebView webView, String url) {
        if (url.startsWith("https://nid.naver.com") && Build.VERSION.SDK_INT >= 19) {
            webView.evaluateJavascript("document.getElementById('back').remove();", null);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return BootpayUrlHelper.shouldOverrideUrlLoading(view, url);
    }

    @TargetApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        String url = request.getUrl().toString();
        return this.shouldOverrideUrlLoading(view, url);
    }

    public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
        return super.shouldOverrideKeyEvent(view, event);
    }
}

