/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import java.util.Optional;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.query.StaticQuery;
import org.socialsignin.spring.data.dynamodb.repository.QueryConstants;
import org.socialsignin.spring.data.dynamodb.repository.query.AbstractDynamoDBQueryCreator;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

public class DynamoDBCountQueryCreator<T, ID>
extends AbstractDynamoDBQueryCreator<T, ID, Long> {
    private boolean pageQuery;

    public DynamoDBCountQueryCreator(PartTree tree, DynamoDBEntityInformation<T, ID> entityMetadata, DynamoDBOperations dynamoDBOperations, boolean pageQuery) {
        super(tree, entityMetadata, Optional.empty(), Optional.empty(), QueryConstants.ConsistentReadMode.DEFAULT, dynamoDBOperations);
        this.pageQuery = pageQuery;
    }

    public DynamoDBCountQueryCreator(PartTree tree, ParameterAccessor parameterAccessor, DynamoDBEntityInformation<T, ID> entityMetadata, DynamoDBOperations dynamoDBOperations, boolean pageQuery) {
        super(tree, parameterAccessor, entityMetadata, Optional.empty(), Optional.empty(), QueryConstants.ConsistentReadMode.DEFAULT, dynamoDBOperations);
        this.pageQuery = pageQuery;
    }

    protected Query<Long> complete(@Nullable DynamoDBQueryCriteria<T, ID> criteria, Sort sort) {
        if (criteria == null) {
            return new StaticQuery<Long>(1L);
        }
        return criteria.buildCountQuery(this.dynamoDBOperations, this.pageQuery);
    }
}

