/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.utils;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public interface SortHandler {
    default public void ensureNoSort(Pageable pageable) {
        Sort sort = pageable.getSort();
        this.ensureNoSort(sort);
    }

    default public void ensureNoSort(Sort sort) throws UnsupportedOperationException {
        if (!Sort.unsorted().equals((Object)sort)) {
            this.throwUnsupportedSortOperationException();
        }
    }

    default public <T> T throwUnsupportedSortOperationException() {
        throw new UnsupportedOperationException("Sorting not supported for scan expressions");
    }
}

