/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.CountByHashKeyQuery;
import org.socialsignin.spring.data.dynamodb.query.MultipleEntityQueryRequestQuery;
import org.socialsignin.spring.data.dynamodb.query.MultipleEntityScanExpressionQuery;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.query.QueryRequestCountQuery;
import org.socialsignin.spring.data.dynamodb.query.ScanExpressionCountQuery;
import org.socialsignin.spring.data.dynamodb.query.SingleEntityLoadByHashKeyQuery;
import org.socialsignin.spring.data.dynamodb.repository.query.AbstractDynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryCriteria;
import org.socialsignin.spring.data.dynamodb.repository.support.DynamoDBEntityInformation;
import org.socialsignin.spring.data.dynamodb.utils.SortHandler;

public class DynamoDBEntityWithHashKeyOnlyCriteria<T, ID extends Serializable>
extends AbstractDynamoDBQueryCriteria<T, ID> {
    private DynamoDBEntityInformation<T, ID> entityInformation;

    public DynamoDBEntityWithHashKeyOnlyCriteria(DynamoDBEntityInformation<T, ID> entityInformation, DynamoDBMapperTableModel<T> tableModel) {
        super(entityInformation, tableModel);
        this.entityInformation = entityInformation;
    }

    @Override
    protected Query<T> buildSingleEntityLoadQuery(DynamoDBOperations dynamoDBOperations) {
        return new SingleEntityLoadByHashKeyQuery(dynamoDBOperations, this.clazz, this.getHashKeyPropertyValue());
    }

    @Override
    protected Query<Long> buildSingleEntityCountQuery(DynamoDBOperations dynamoDBOperations) {
        return new CountByHashKeyQuery(dynamoDBOperations, this.clazz, this.getHashKeyPropertyValue());
    }

    @Override
    protected Query<T> buildFinderQuery(DynamoDBOperations dynamoDBOperations) {
        if (this.isApplicableForGlobalSecondaryIndex()) {
            List<Condition> hashKeyConditions = this.getHashKeyConditions();
            QueryRequest queryRequest = this.buildQueryRequest(dynamoDBOperations.getOverriddenTableName(this.clazz, this.entityInformation.getDynamoDBTableName()), this.getGlobalSecondaryIndexName(), this.getHashKeyAttributeName(), null, null, hashKeyConditions, null);
            return new MultipleEntityQueryRequestQuery(dynamoDBOperations, this.entityInformation.getJavaType(), queryRequest);
        }
        return new MultipleEntityScanExpressionQuery(dynamoDBOperations, this.clazz, this.buildScanExpression());
    }

    @Override
    protected Query<Long> buildFinderCountQuery(DynamoDBOperations dynamoDBOperations, boolean pageQuery) {
        if (this.isApplicableForGlobalSecondaryIndex()) {
            List<Condition> hashKeyConditions = this.getHashKeyConditions();
            QueryRequest queryRequest = this.buildQueryRequest(dynamoDBOperations.getOverriddenTableName(this.clazz, this.entityInformation.getDynamoDBTableName()), this.getGlobalSecondaryIndexName(), this.getHashKeyAttributeName(), null, null, hashKeyConditions, null);
            return new QueryRequestCountQuery(dynamoDBOperations, queryRequest);
        }
        return new ScanExpressionCountQuery(dynamoDBOperations, this.clazz, this.buildScanExpression(), pageQuery);
    }

    @Override
    protected boolean isOnlyHashKeySpecified() {
        return this.attributeConditions.size() == 0 && this.isHashKeySpecified();
    }

    @Override
    public boolean isApplicableForLoad() {
        return this.isOnlyHashKeySpecified();
    }

    public DynamoDBScanExpression buildScanExpression() {
        SortHandler.ensureNoSort(this.sort);
        DynamoDBScanExpression scanExpression = new DynamoDBScanExpression();
        if (this.isHashKeySpecified()) {
            scanExpression.addFilterCondition(this.getHashKeyAttributeName(), this.createSingleValueCondition(this.getHashKeyPropertyName(), ComparisonOperator.EQ, this.getHashKeyAttributeValue(), this.getHashKeyAttributeValue().getClass(), true));
        }
        for (Map.Entry conditionEntry : this.attributeConditions.entrySet()) {
            for (Condition condition : (List)conditionEntry.getValue()) {
                scanExpression.addFilterCondition((String)conditionEntry.getKey(), condition);
            }
        }
        return scanExpression;
    }

    @Override
    public DynamoDBQueryCriteria<T, ID> withPropertyEquals(String propertyName, Object value, Class<?> propertyType) {
        if (this.isHashKeyProperty(propertyName)) {
            return this.withHashKeyEquals(value);
        }
        Condition condition = this.createSingleValueCondition(propertyName, ComparisonOperator.EQ, value, propertyType, false);
        return this.withCondition(propertyName, condition);
    }
}

