/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping.event;

import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterLoadEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterQueryEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.AfterScanEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeDeleteEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.BeforeSaveEvent;
import org.socialsignin.spring.data.dynamodb.mapping.event.DynamoDBMappingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractDynamoDBEventListener<E>
implements ApplicationListener<DynamoDBMappingEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDynamoDBEventListener.class);
    private final Class<?> domainClass;

    public AbstractDynamoDBEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractDynamoDBEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    protected Class<?> getDomainClass() {
        return this.domainClass;
    }

    public void onApplicationEvent(DynamoDBMappingEvent<?> event) {
        Object source = event.getSource();
        assert (source != null);
        if (event instanceof AfterScanEvent && source instanceof PaginatedScanList) {
            this.publishEachElement((List<E>)((PaginatedScanList)source), new Consumer<E>(){

                @Override
                public void accept(E e) {
                    AbstractDynamoDBEventListener.this.onAfterScan(e);
                }
            });
            return;
        }
        if (event instanceof AfterQueryEvent && source instanceof PaginatedQueryList) {
            this.publishEachElement((List<E>)((PaginatedQueryList)source), new Consumer<E>(){

                @Override
                public void accept(E e) {
                    AbstractDynamoDBEventListener.this.onAfterQuery(e);
                }
            });
            return;
        }
        if (this.domainClass.isAssignableFrom(source.getClass())) {
            if (event instanceof BeforeSaveEvent) {
                this.onBeforeSave(source);
                return;
            }
            if (event instanceof AfterSaveEvent) {
                this.onAfterSave(source);
                return;
            }
            if (event instanceof BeforeDeleteEvent) {
                this.onBeforeDelete(source);
                return;
            }
            if (event instanceof AfterDeleteEvent) {
                this.onAfterDelete(source);
                return;
            }
            if (event instanceof AfterLoadEvent) {
                this.onAfterLoad(source);
                return;
            }
        }
        assert (false);
    }

    private void publishEachElement(List<E> list, Consumer<E> publishMethod) {
        for (E o : list) {
            if (!this.domainClass.isAssignableFrom(o.getClass())) continue;
            publishMethod.accept(o);
        }
    }

    public void onBeforeSave(E source) {
        LOG.debug("onBeforeSave({}, {})", source);
    }

    public void onAfterSave(E source) {
        LOG.debug("onAfterSave({}, {})", source);
    }

    public void onAfterLoad(E source) {
        LOG.debug("onAfterLoad({})", source);
    }

    public void onAfterDelete(E source) {
        LOG.debug("onAfterDelete({})", source);
    }

    public void onBeforeDelete(E source) {
        LOG.debug("onBeforeDelete({})", source);
    }

    public void onAfterScan(E source) {
        LOG.debug("onAfterScan({})", source);
    }

    public void onAfterQuery(E source) {
        LOG.debug("onAfterQuery({})", source);
    }

    private static interface Consumer<T> {
        public void accept(T var1);
    }
}

