/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.OperatingSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlFilter {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public List<URL> filterByOs(List<URL> list, String osName) {
        this.log.trace("URLs before filtering by OS ({}): {}", (Object)osName, list);
        ArrayList<URL> out = new ArrayList<URL>();
        for (URL url : list) {
            for (OperatingSystem os : OperatingSystem.values()) {
                if ((!osName.contains(os.name()) || !url.getFile().toUpperCase().contains(os.name())) && (!osName.equalsIgnoreCase("mac") || !url.getFile().toLowerCase().contains("osx")) || out.contains(url)) continue;
                out.add(url);
            }
        }
        this.log.trace("URLs after filtering by OS ({}): {}", (Object)osName, out);
        return out;
    }

    public List<URL> filterByArch(List<URL> list, Architecture arch, boolean forcedArch) {
        this.log.trace("URLs before filtering by architecture ({}): {}", (Object)arch, list);
        List<URL> out = new ArrayList<URL>(list);
        if ((forcedArch || out.size() > 1) && arch != null) {
            for (URL url : list) {
                if (!url.getFile().contains("x86") && !url.getFile().contains("64") && !url.getFile().contains("i686") && !url.getFile().contains("32") || url.getFile().contains(arch.toString())) continue;
                out.remove(url);
            }
        }
        this.log.trace("URLs after filtering by architecture ({}): {}", (Object)arch, out);
        if (out.isEmpty() && !forcedArch && !list.isEmpty()) {
            out = Collections.singletonList(list.get(list.size() - 1));
            this.log.trace("Empty URL list after filtering by architecture ... using last candidate: {}", out);
        }
        return out;
    }

    public List<URL> filterByDistro(List<URL> list, String version) throws IOException {
        String distro = this.getDistroName();
        this.log.trace("URLs before filtering by Linux distribution ({}): {}", (Object)distro, list);
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version) || url.getFile().contains(distro)) continue;
            out.remove(url);
        }
        this.log.trace("URLs after filtering by Linux distribution ({}): {}", (Object)distro, out);
        return out;
    }

    public List<URL> filterByIgnoredVersions(List<URL> list, String ... ignoredVersions) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("URLs before filtering by ignored versions ({}): {}", (Object)Arrays.toString(ignoredVersions), list);
        }
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            for (String s : ignoredVersions) {
                if (!url.getFile().contains(s)) continue;
                this.log.info("Ignoring version {}", (Object)s);
                out.remove(url);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("URLs after filtering by ignored versions ({}): {}", (Object)Arrays.toString(ignoredVersions), out);
        }
        return out;
    }

    private String getDistroName() throws IOException {
        File fileVersion;
        String out = "";
        String key = "UBUNTU_CODENAME";
        File dir = new File(File.separator + "etc");
        File[] fileList = new File[]{};
        if (dir.exists()) {
            fileList = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith("-release");
                }
            });
        }
        if ((fileVersion = new File(File.separator + "proc", "version")).exists()) {
            fileList = Arrays.copyOf(fileList, fileList.length + 1);
            fileList[fileList.length - 1] = fileVersion;
        }
        for (File f : fileList) {
            if (f.isDirectory()) continue;
            try (BufferedReader myReader = new BufferedReader(new FileReader(f));){
                String strLine = null;
                while ((strLine = myReader.readLine()) != null) {
                    if (!strLine.contains("UBUNTU_CODENAME")) continue;
                    int beginIndex = "UBUNTU_CODENAME".length();
                    out = strLine.substring(beginIndex + 1);
                }
            }
        }
        return out;
    }
}

