/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.VoidDriverManager;
import java.net.URL;
import java.util.List;

public class WebDriverManager
extends BrowserManager {
    private static BrowserManager instance;
    private static Class<? extends BrowserManager> browserManagerClass;

    public static synchronized BrowserManager getInstance(Class<?> webDriverClass) {
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                browserManagerClass = ChromeDriverManager.class;
                break;
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                browserManagerClass = OperaDriverManager.class;
                break;
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                browserManagerClass = InternetExplorerDriverManager.class;
                break;
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                browserManagerClass = EdgeDriverManager.class;
                break;
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                browserManagerClass = PhantomJsDriverManager.class;
                break;
            }
            case "org.openqa.selenium.firefox.MarionetteDriver": 
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                browserManagerClass = FirefoxDriverManager.class;
                break;
            }
            default: {
                browserManagerClass = VoidDriverManager.class;
            }
        }
        try {
            log.debug("Creating instance of {}", browserManagerClass);
            instance = browserManagerClass.newInstance();
        }
        catch (Throwable e) {
            String errMessage = "Error creating WebDriverManager";
            log.error(errMessage, e);
            throw new RuntimeException(errMessage, e);
        }
        return instance;
    }

    @Override
    protected List<URL> getDrivers() throws Exception {
        return instance.getDrivers();
    }

    @Override
    protected String getExportParameter() {
        return instance.getExportParameter();
    }

    @Override
    protected String getDriverVersionKey() {
        return instance.getDriverVersionKey();
    }

    @Override
    protected String getDriverUrlKey() {
        return instance.getDriverUrlKey();
    }

    @Override
    protected List<String> getDriverName() {
        return instance.getDriverName();
    }
}

