/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;

public class OperaDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.OPERA;
    }

    @Override
    protected String getDriverName() {
        return "operadriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getOperaDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getOperaVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setOperaDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setOperaVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getOperaDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getOperaDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getOperaDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setOperaDriverUrl(url);
    }

    @Override
    protected String getCurrentVersion(URL url) {
        if (this.config().isUseMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            String currentVersion = url.getFile().substring(j, i);
            return currentVersion;
        }
        String currentVersion = url.getFile().substring(url.getFile().indexOf("/v") + 2, url.getFile().lastIndexOf("/"));
        if (currentVersion.startsWith(".")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        if (this.isUseMirror()) {
            String versionPath = driverVersion;
            if (!driverVersion.isEmpty()) {
                versionPath = driverVersion.startsWith("0") ? "v" + versionPath : "v." + versionPath;
            }
            return this.getDriversFromMirror(this.getMirrorUrl().get(), versionPath);
        }
        return this.getDriversFromGitHub(driverVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<File> postDownload(File archive) {
        log.trace("Post processing for Opera: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles(this.getFolderFilter())[0];
        if (!extractFolder.isFile()) {
            File target;
            try {
                File operadriver;
                boolean isOperaDriver;
                log.trace("Opera extract folder (to be deleted): {}", (Object)extractFolder);
                File[] listFiles = extractFolder.listFiles();
                int i = 0;
                do {
                    if (i >= listFiles.length) {
                        throw new WebDriverManagerException("Driver for Opera not found in zip file");
                    }
                    operadriver = listFiles[i];
                    isOperaDriver = operadriver.getName().contains(this.getDriverName());
                    ++i;
                    log.trace("{} is valid: {}", (Object)operadriver, (Object)isOperaDriver);
                } while (!isOperaDriver);
                log.info("Operadriver: {}", (Object)operadriver);
                target = new File(archive.getParentFile().getAbsolutePath(), operadriver.getName());
                log.trace("Operadriver target: {}", (Object)target);
                this.downloader.renameFile(operadriver, target);
            }
            finally {
                this.downloader.deleteFolder(extractFolder);
            }
            return Collections.singletonList(target);
        }
        return super.postDownload(archive);
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }

    @Override
    protected Capabilities getCapabilities() {
        ChromeOptions options = new ChromeOptions();
        Optional<Path> browserPath = this.getBrowserPath();
        if (browserPath.isPresent()) {
            options.setBinary(browserPath.get().toFile());
        }
        return options;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setOperaDriverExport(exportParameter);
        return this;
    }
}

