/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.WdmServer;
import io.github.bonigarcia.wdm.cache.CacheHandler;
import io.github.bonigarcia.wdm.cache.ResolutionCache;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.docker.DockerContainer;
import io.github.bonigarcia.wdm.docker.DockerService;
import io.github.bonigarcia.wdm.managers.ChromeDriverManager;
import io.github.bonigarcia.wdm.managers.ChromiumDriverManager;
import io.github.bonigarcia.wdm.managers.EdgeDriverManager;
import io.github.bonigarcia.wdm.managers.FirefoxDriverManager;
import io.github.bonigarcia.wdm.managers.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.managers.OperaDriverManager;
import io.github.bonigarcia.wdm.managers.SafariDriverManager;
import io.github.bonigarcia.wdm.managers.VoidDriverManager;
import io.github.bonigarcia.wdm.online.Downloader;
import io.github.bonigarcia.wdm.online.GitHubApi;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.online.S3NamespaceContext;
import io.github.bonigarcia.wdm.online.UrlHandler;
import io.github.bonigarcia.wdm.versions.VersionComparator;
import io.github.bonigarcia.wdm.versions.VersionDetector;
import io.github.bonigarcia.wdm.webdriver.WebDriverBrowser;
import io.github.bonigarcia.wdm.webdriver.WebDriverCreator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    protected static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static final String LATEST_RELEASE = "LATEST_RELEASE";
    protected static final NamespaceContext S3_NAMESPACE_CONTEXT = new S3NamespaceContext();
    protected static final String IN_DOCKER = "-in-docker";
    protected static final String CLI_SERVER = "server";
    protected static final String CLI_RESOLVER = "resolveDriverFor";
    protected static final String CLI_DOCKER = "runInDocker";
    protected Config config = new Config();
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected ResolutionCache resolutionCache;
    protected CacheHandler cacheHandler = new CacheHandler(this.config);
    protected VersionDetector versionDetector;
    protected WebDriverCreator webDriverCreator;
    protected DockerService dockerService;
    protected boolean mirrorLog;
    protected boolean forcedArch;
    protected int retryCount = 0;
    protected Capabilities capabilities;
    protected boolean shutdownHook = false;
    protected boolean dockerEnabled = false;
    protected boolean androidEnabled = false;
    protected List<WebDriverBrowser> webDriverList;
    protected String downloadedDriverVersion;
    protected String downloadedDriverPath;

    protected abstract List<URL> getDriverUrls() throws IOException;

    protected abstract String getDriverName();

    protected abstract String getDriverVersion();

    protected abstract void setDriverVersion(String var1);

    protected abstract String getBrowserVersion();

    protected abstract void setBrowserVersion(String var1);

    protected abstract void setDriverUrl(URL var1);

    protected abstract URL getDriverUrl();

    protected abstract Optional<URL> getMirrorUrl();

    protected abstract Optional<String> getExportParameter();

    public abstract DriverManagerType getDriverManagerType();

    protected WebDriverManager() {
        this.httpClient = new HttpClient(this.config);
        this.downloader = new Downloader(this.httpClient, this.config, this::postDownload);
        this.resolutionCache = new ResolutionCache(this.config);
        this.dockerService = new DockerService(this.config, this.httpClient, this.resolutionCache);
        this.versionDetector = new VersionDetector(this.config, this.httpClient);
        this.webDriverList = new CopyOnWriteArrayList<WebDriverBrowser>();
        this.webDriverCreator = new WebDriverCreator(this.config);
    }

    public synchronized Config config() {
        return this.config;
    }

    public static synchronized WebDriverManager chromedriver() {
        return new ChromeDriverManager();
    }

    public static synchronized WebDriverManager chromiumdriver() {
        return new ChromiumDriverManager();
    }

    public static synchronized WebDriverManager firefoxdriver() {
        return new FirefoxDriverManager();
    }

    public static synchronized WebDriverManager operadriver() {
        return new OperaDriverManager();
    }

    public static synchronized WebDriverManager edgedriver() {
        return new EdgeDriverManager();
    }

    public static synchronized WebDriverManager iedriver() {
        return new InternetExplorerDriverManager();
    }

    public static synchronized WebDriverManager safaridriver() {
        return new SafariDriverManager();
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new VoidDriverManager();
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == DriverManagerType.CHROMIUM) {
            return WebDriverManager.chromiumdriver();
        }
        return WebDriverManager.getDriver(driverManagerType.browserClass());
    }

    public static synchronized WebDriverManager getInstance(String browserName) {
        DriverManagerType managerType;
        String browserNameUpperCase;
        switch (browserNameUpperCase = browserName.toUpperCase(Locale.ROOT)) {
            case "OPERABLINK": {
                managerType = DriverManagerType.OPERA;
                break;
            }
            case "MSEDGE": 
            case "MICROSOFTEDGE": {
                managerType = DriverManagerType.EDGE;
                break;
            }
            case "INTERNET EXPLORER": {
                managerType = DriverManagerType.IEXPLORER;
                break;
            }
            default: {
                try {
                    managerType = DriverManagerType.valueOf(browserNameUpperCase);
                    break;
                }
                catch (Exception e) {
                    String errorMessage = String.format("The browser name '%s' is not recognized", browserName);
                    log.trace(errorMessage);
                    throw new WebDriverManagerException(errorMessage);
                }
            }
        }
        return WebDriverManager.getInstance(managerType);
    }

    public static synchronized WebDriverManager getInstance(Class<?> webDriverClass) {
        return WebDriverManager.getDriver(webDriverClass.getName());
    }

    protected static synchronized WebDriverManager getDriver(String webDriverClass) {
        switch (webDriverClass) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.chromium.ChromiumDriver": {
                return WebDriverManager.chromiumdriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.safari.SafariDriver": {
                return WebDriverManager.safaridriver();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance() {
        WebDriverManager manager = WebDriverManager.voiddriver();
        String defaultBrowser = manager.config().getDefaultBrowser();
        try {
            if (defaultBrowser.contains(IN_DOCKER)) {
                defaultBrowser = defaultBrowser.substring(0, defaultBrowser.indexOf(IN_DOCKER));
                manager = WebDriverManager.getInstance(DriverManagerType.valueOf(defaultBrowser.toUpperCase(Locale.ROOT)));
                manager.dockerEnabled = true;
            } else {
                manager = WebDriverManager.getInstance(DriverManagerType.valueOf(defaultBrowser.toUpperCase(Locale.ROOT)));
            }
            return manager;
        }
        catch (Exception e) {
            log.error("Error trying to get manager for browser {}", (Object)defaultBrowser, (Object)e);
            return manager;
        }
    }

    public synchronized void setup() {
        if (this.config().getClearingDriverCache()) {
            this.clearDriverCache();
        }
        if (this.config().getClearingResolutionCache()) {
            this.clearResolutionCache();
        }
        if (this.dockerEnabled || !Config.isNullOrEmpty(this.config().getRemoteAddress())) {
            return;
        }
        if (this.getDriverManagerType() != null) {
            this.manage(this.getDriverVersion());
        }
    }

    public synchronized WebDriver create() {
        this.setup();
        return this.instantiateDriver();
    }

    public synchronized List<WebDriver> create(int numberOfBrowser) {
        ArrayList<WebDriver> browserList = new ArrayList<WebDriver>();
        for (int i = 0; i < numberOfBrowser; ++i) {
            if (i == 0) {
                this.setup();
            }
            browserList.add(this.instantiateDriver());
        }
        return browserList;
    }

    public Optional<Path> getBrowserPath() {
        return this.versionDetector.getBrowserPath(this.getDriverManagerType().getBrowserNameLowerCase());
    }

    public WebDriverManager browserInDocker() {
        this.dockerEnabled = true;
        return this;
    }

    public WebDriverManager browserInDockerAndroid() {
        throw new WebDriverManagerException(this.getDriverManagerType().getBrowserName() + " is not available in Docker Android");
    }

    public WebDriverManager dockerDaemonUrl(String daemonUrl) {
        this.config().setDockerDaemonUrl(daemonUrl);
        return this;
    }

    public WebDriverManager dockerNetwork(String network) {
        this.config().setDockerNetwork(network);
        return this;
    }

    public WebDriverManager dockerTimezone(String timezone) {
        this.config().setDockerTimezone(timezone);
        return this;
    }

    public WebDriverManager dockerLang(String lang) {
        this.config().setDockerLang(lang);
        return this;
    }

    public WebDriverManager dockerShmSize(String size) {
        this.config().setDockerShmSize(size);
        return this;
    }

    public WebDriverManager dockerTmpfsSize(String size) {
        this.config().setDockerTmpfsSize(size);
        return this;
    }

    public WebDriverManager dockerTmpfsMount(String mount) {
        this.config().setDockerTmpfsMount(mount);
        return this;
    }

    public WebDriverManager dockerVolumes(String[] volumes) {
        this.config().setDockerVolumes(String.join((CharSequence)",", volumes));
        return this;
    }

    public WebDriverManager dockerVolume(String volume) {
        this.config().setDockerVolumes(volume);
        return this;
    }

    public WebDriverManager dockerScreenResolution(String screenResolution) {
        this.config().setDockerScreenResolution(screenResolution);
        return this;
    }

    public WebDriverManager dockerRecordingFrameRate(int frameRate) {
        this.config().setDockerRecordingFrameRate(frameRate);
        return this;
    }

    public WebDriverManager enableVnc() {
        this.config().setDockerEnableVnc(true);
        return this;
    }

    public WebDriverManager enableRecording() {
        this.config().setDockerEnableRecording(true);
        return this;
    }

    public WebDriverManager recordingPrefix(String prefix) {
        this.config().setDockerRecordingPrefix(prefix);
        return this;
    }

    public WebDriverManager recordingOutput(String path) {
        return this.recordingOutput(Paths.get(path, new String[0]));
    }

    public WebDriverManager recordingOutput(Path path) {
        this.config().setDockerRecordingOutput(path);
        return this;
    }

    public WebDriverManager capabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public WebDriverManager remoteAddress(String remoteAddress) {
        this.config().setRemoteAddress(remoteAddress);
        return this;
    }

    public WebDriverManager dockerImage(String dockerImage) {
        this.config().setDockerCustomImage(dockerImage);
        return this;
    }

    public WebDriverManager driverVersion(String driverVersion) {
        this.setDriverVersion(driverVersion);
        return this;
    }

    public WebDriverManager browserVersion(String browserVersion) {
        this.setBrowserVersion(browserVersion);
        return this;
    }

    public WebDriverManager architecture(Architecture architecture) {
        this.config().setArchitecture(architecture);
        this.forcedArch = true;
        return this;
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return this;
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return this;
    }

    public WebDriverManager arm64() {
        this.architecture(Architecture.ARM64);
        return this;
    }

    public WebDriverManager win() {
        this.operatingSystem(OperatingSystem.WIN);
        return this;
    }

    public WebDriverManager linux() {
        this.operatingSystem(OperatingSystem.LINUX);
        return this;
    }

    public WebDriverManager mac() {
        this.operatingSystem(OperatingSystem.MAC);
        return this;
    }

    public WebDriverManager operatingSystem(OperatingSystem os) {
        this.config().setOs(os.name());
        return this;
    }

    public WebDriverManager forceDownload() {
        this.config().setForceDownload(true);
        return this;
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        this.setDriverUrl(url);
        return this;
    }

    public WebDriverManager useMirror() {
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (!mirrorUrl.isPresent()) {
            throw new WebDriverManagerException("Mirror URL not available");
        }
        this.config().setUseMirror(true);
        return this;
    }

    public WebDriverManager proxy(String proxy) {
        this.config().setProxy(proxy);
        return this;
    }

    public WebDriverManager proxyUser(String proxyUser) {
        this.config().setProxyUser(proxyUser);
        return this;
    }

    public WebDriverManager proxyPass(String proxyPass) {
        this.config().setProxyPass(proxyPass);
        return this;
    }

    public WebDriverManager useBetaVersions() {
        this.config().setUseBetaVersions(true);
        return this;
    }

    public WebDriverManager ignoreDriverVersions(String ... driverVersions) {
        this.config().setIgnoreVersions(driverVersions);
        return this;
    }

    public WebDriverManager gitHubToken(String gitHubToken) {
        this.config().setGitHubToken(gitHubToken);
        return this;
    }

    public WebDriverManager timeout(int timeout) {
        this.config().setTimeout(timeout);
        return this;
    }

    public WebDriverManager properties(String properties) {
        this.config().setProperties(properties);
        return this;
    }

    public WebDriverManager cachePath(String cachePath) {
        this.config().setCachePath(cachePath);
        return this;
    }

    public WebDriverManager resolutionCachePath(String resolutionCachePath) {
        this.config().setResolutionCachePath(resolutionCachePath);
        return this;
    }

    public WebDriverManager avoidExport() {
        this.config().setAvoidExport(true);
        return this;
    }

    public WebDriverManager avoidOutputTree() {
        this.config().setAvoidOutputTree(true);
        return this;
    }

    public WebDriverManager avoidBrowserDetection() {
        this.config().setAvoidBrowserDetection(true);
        return this;
    }

    public WebDriverManager avoidResolutionCache() {
        this.config().setAvoidResolutionCache(true);
        return this;
    }

    public WebDriverManager avoidFallback() {
        this.config().setAvoidFallback(true);
        return this;
    }

    public WebDriverManager avoidReadReleaseFromRepository() {
        this.config().setAvoidReadReleaseFromRepository(true);
        return this;
    }

    public WebDriverManager avoidTmpFolder() {
        this.config().setAvoidTmpFolder(true);
        return this;
    }

    public WebDriverManager avoidUseChromiumDriverSnap() {
        this.config().setUseChromiumDriverSnap(false);
        return this;
    }

    public WebDriverManager ttl(int seconds) {
        this.config().setTtl(seconds);
        return this;
    }

    public WebDriverManager ttlBrowsers(int seconds) {
        this.config().setTtlForBrowsers(seconds);
        return this;
    }

    public WebDriverManager browserVersionDetectionCommand(String browserVersionCommand) {
        this.config().setBrowserVersionDetectionCommand(browserVersionCommand);
        return this;
    }

    public WebDriverManager useLocalVersionsPropertiesFirst() {
        this.config().setVersionsPropertiesOnlineFirst(false);
        return this;
    }

    public WebDriverManager useLocalCommandsPropertiesFirst() {
        this.config().setCommandsPropertiesOnlineFirst(false);
        return this;
    }

    public WebDriverManager versionsPropertiesUrl(URL url) {
        this.config().setVersionsPropertiesUrl(url);
        return this;
    }

    public WebDriverManager commandsPropertiesUrl(URL url) {
        this.config().setCommandsPropertiesUrl(url);
        return this;
    }

    public WebDriverManager clearResolutionCache() {
        this.resolutionCache.clear();
        return this;
    }

    public WebDriverManager clearDriverCache() {
        String cachePath = this.config().getCachePath();
        try {
            log.debug("Clearing driver cache at {}", (Object)cachePath);
            FileUtils.cleanDirectory((File)new File(cachePath));
        }
        catch (Exception e) {
            log.warn("Exception deleting driver cache at {}", (Object)cachePath, (Object)e);
        }
        return this;
    }

    public WebDriverManager browserVersionDetectionRegex(String regex) {
        this.config().setBrowserVersionDetectionRegex(regex);
        return this;
    }

    public void reset() {
        this.config().reset();
        this.mirrorLog = false;
        this.forcedArch = false;
        this.retryCount = 0;
        this.shutdownHook = false;
        this.dockerEnabled = false;
        this.androidEnabled = false;
        this.capabilities = null;
    }

    public String getDownloadedDriverPath() {
        return this.downloadedDriverPath;
    }

    public String getDownloadedDriverVersion() {
        return this.downloadedDriverVersion;
    }

    public List<String> getDriverVersions() {
        try {
            List<URL> driverUrls = this.getDriverUrls();
            ArrayList<String> driverVersionList = new ArrayList<String>();
            for (URL url : driverUrls) {
                String driverVersion = this.getCurrentVersion(url);
                if (driverVersion.isEmpty() || driverVersion.equalsIgnoreCase("icons") || driverVersionList.contains(driverVersion)) continue;
                driverVersionList.add(driverVersion);
            }
            log.trace("Driver version list before sorting {}", driverVersionList);
            Collections.sort(driverVersionList, new VersionComparator());
            return driverVersionList;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    public WebDriver getWebDriver() {
        List<WebDriver> driverList = this.getWebDriverList();
        return driverList.isEmpty() ? null : driverList.iterator().next();
    }

    public List<WebDriver> getWebDriverList() {
        List<Object> webdriverList = new ArrayList<WebDriver>();
        if (this.webDriverList.isEmpty()) {
            log.warn("WebDriver object(s) not available");
        } else {
            webdriverList = this.webDriverList.stream().map(WebDriverBrowser::getDriver).collect(Collectors.toList());
        }
        return webdriverList;
    }

    public synchronized void quit() {
        this.webDriverList.stream().forEach(this::quit);
        this.webDriverList.clear();
    }

    public synchronized void quit(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            WebDriverBrowser driverBrowser = webDriverBrowser.get();
            this.quit(driverBrowser);
            this.webDriverList.remove(driverBrowser);
        }
    }

    public synchronized void stopDockerRecording() {
        this.webDriverList.stream().forEach(this::stopDockerRecording);
    }

    public synchronized void stopDockerRecording(WebDriver driver) {
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            this.stopDockerRecording(webDriverBrowser.get());
        }
    }

    protected synchronized void stopDockerRecording(WebDriverBrowser driverBrowser) {
        List<DockerContainer> dockerContainerList = driverBrowser.getDockerContainerList();
        if (dockerContainerList != null && !dockerContainerList.isEmpty()) {
            DockerContainer recorderContainer = dockerContainerList.get(0);
            this.dockerService.stopAndRemoveContainer(recorderContainer);
            dockerContainerList.remove(0);
        }
    }

    protected synchronized void quit(WebDriverBrowser driverBrowser) {
        try {
            List<DockerContainer> dockerContainerList;
            SessionId sessionId;
            WebDriver driver = driverBrowser.getDriver();
            if (driver != null && (sessionId = ((RemoteWebDriver)driver).getSessionId()) != null) {
                log.debug("Quitting {}", (Object)driver);
                driver.quit();
            }
            if ((dockerContainerList = driverBrowser.getDockerContainerList()) != null) {
                dockerContainerList.stream().forEach(this.dockerService::stopAndRemoveContainer);
            }
        }
        catch (Exception e) {
            log.warn("Exception closing {} ({})", new Object[]{driverBrowser.getDriver(), e.getMessage(), e});
        }
    }

    public String getDockerBrowserContainerId(WebDriver driver) {
        return (String)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getBrowserContainerId);
    }

    public String getDockerBrowserContainerId() {
        return (String)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getBrowserContainerId);
    }

    public URL getDockerSeleniumServerUrl(WebDriver driver) {
        return (URL)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getSeleniumServerUrl);
    }

    public URL getDockerSeleniumServerUrl() {
        return (URL)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getSeleniumServerUrl);
    }

    public URL getDockerNoVncUrl(WebDriver driver) {
        return (URL)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getNoVncUrl);
    }

    public URL getDockerNoVncUrl() {
        return (URL)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getNoVncUrl);
    }

    public Path getDockerRecordingPath(WebDriver driver) {
        return (Path)this.getPropertyFromWebDriverBrowser(driver, WebDriverBrowser::getRecordingPath);
    }

    public Path getDockerRecordingPath() {
        return (Path)this.getPropertyFromFirstWebDriverBrowser(WebDriverBrowser::getRecordingPath);
    }

    public DockerService getDockerService() {
        return this.dockerService;
    }

    protected Object getPropertyFromWebDriverBrowser(WebDriver driver, Function<WebDriverBrowser, Object> function) {
        Object object = null;
        Optional<WebDriverBrowser> webDriverBrowser = this.findWebDriverBrowser(driver);
        if (webDriverBrowser.isPresent()) {
            object = function.apply(webDriverBrowser.get());
        }
        return object;
    }

    protected Optional<WebDriverBrowser> findWebDriverBrowser(WebDriver driver) {
        for (WebDriverBrowser webDriver : this.webDriverList) {
            if (webDriver.getIdentityHash() != webDriver.calculateIdentityHash(driver)) continue;
            return Optional.of(webDriver);
        }
        return Optional.empty();
    }

    protected Object getPropertyFromFirstWebDriverBrowser(Function<WebDriverBrowser, Object> function) {
        Object object = null;
        if (this.webDriverList.isEmpty()) {
            log.warn("Property not available since there is no browsers in Docker");
        } else {
            object = function.apply(this.webDriverList.get(0));
        }
        return object;
    }

    protected void manage(String driverVersion) {
        try (HttpClient wdmHttpClient = this.httpClient;){
            String exportValue;
            if (this.isUnknown(driverVersion)) {
                driverVersion = this.resolveDriverVersion(driverVersion);
            }
            if (this.versionDetector.isSnap() && this.config.isUseChromiumDriverSnap()) {
                String chromiumDriverSnapPath = this.config().getChromiumDriverSnapPath();
                File snapChromiumDriverPath = new File(chromiumDriverSnapPath);
                boolean existsSnap = snapChromiumDriverPath.exists();
                if (existsSnap) {
                    log.debug("Found {} snap", (Object)this.getDriverManagerType());
                    this.exportDriver(chromiumDriverSnapPath);
                }
                return;
            }
            Optional<Object> driverInCache = Optional.empty();
            if (!this.isUnknown(driverVersion)) {
                driverInCache = this.cacheHandler.getDriverFromCache(driverVersion, this.getDriverName(), this.getDriverManagerType(), this.config().getArchitecture(), this.config().getOs());
            }
            if (driverInCache.isPresent() && !this.config().isForceDownload()) {
                log.debug("Driver {} {} found in cache", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
                exportValue = (String)driverInCache.get();
                this.downloadedDriverVersion = driverVersion;
            } else {
                exportValue = this.download(driverVersion);
            }
            this.exportDriver(exportValue);
        }
        catch (Exception e) {
            this.handleException(e, driverVersion);
        }
    }

    protected String resolveDriverVersion(String driverVersion) {
        String preferenceKey = this.getKeyForResolutionCache();
        Optional<String> optionalBrowserVersion = Optional.ofNullable(this.getBrowserVersion()).filter(StringUtils::isNotEmpty);
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.getValueFromResolutionCache(preferenceKey);
        }
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.detectBrowserVersion();
        }
        if (optionalBrowserVersion.isPresent()) {
            preferenceKey = this.getKeyForResolutionCache() + optionalBrowserVersion.get();
            Optional<String> optionalDriverVersion = this.getValueFromResolutionCache(preferenceKey);
            if (!optionalDriverVersion.isPresent()) {
                optionalDriverVersion = this.getDriverVersionFromRepository(optionalBrowserVersion);
            }
            if (!optionalDriverVersion.isPresent()) {
                optionalDriverVersion = this.versionDetector.getDriverVersionFromProperties(preferenceKey);
            }
            if (optionalDriverVersion.isPresent()) {
                driverVersion = optionalDriverVersion.get();
                log.info("Using {} {} (resolved driver for {} {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType().getBrowserName(), optionalBrowserVersion.get()});
                if (this.config.getIgnoreVersions().contains(driverVersion)) {
                    String formerBrowserVersion = String.valueOf(Integer.parseInt(optionalBrowserVersion.get()) - 1);
                    log.info("The driver {} {} is configured to be ignored ... trying again resolving driver for former version of {} (i.e. {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType(), formerBrowserVersion});
                    this.setBrowserVersion(formerBrowserVersion);
                    return this.resolveDriverVersion("");
                }
                if (!this.versionDetector.isSnap()) {
                    this.storeInResolutionCache(preferenceKey, driverVersion, optionalBrowserVersion.get());
                }
            }
        }
        if (this.isUnknown(driverVersion)) {
            String browserVersionStr = optionalBrowserVersion.isPresent() ? " " + optionalBrowserVersion.get() : "";
            log.debug("The driver version for {}{} is unknown ... trying with latest", (Object)this.getDriverManagerType(), (Object)browserVersionStr);
            Optional<String> latestDriverVersionFromRepository = this.getLatestDriverVersionFromRepository();
            if (latestDriverVersionFromRepository.isPresent()) {
                driverVersion = latestDriverVersionFromRepository.get();
            }
        }
        return driverVersion;
    }

    protected String download(String driverVersion) throws IOException {
        if (driverVersion.startsWith(".")) {
            driverVersion = driverVersion.substring(1);
        }
        UrlHandler urlHandler = this.createUrlHandler(driverVersion);
        URL url = urlHandler.getCandidateUrl();
        this.downloadedDriverVersion = urlHandler.getDriverVersion();
        return this.downloader.download(url, this.downloadedDriverVersion, this.getDriverName(), this.getDriverManagerType());
    }

    protected void exportDriver(String variableValue) {
        this.downloadedDriverPath = variableValue;
        Optional<String> exportParameter = this.getExportParameter();
        if (!this.config.isAvoidExport() && exportParameter.isPresent()) {
            String variableName = exportParameter.get();
            log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
            System.setProperty(variableName, variableValue);
        } else {
            log.info("Driver location: {}", (Object)variableValue);
        }
    }

    protected void storeInResolutionCache(String preferenceKey, String resolvedDriverVersion, String resolvedBrowserVersion) {
        if (this.useResolutionCache()) {
            this.resolutionCache.putValueInResolutionCacheIfEmpty(this.getKeyForResolutionCache(), resolvedBrowserVersion, this.config().getTtlForBrowsers());
            this.resolutionCache.putValueInResolutionCacheIfEmpty(preferenceKey, resolvedDriverVersion, this.config().getTtl());
        }
    }

    protected Optional<String> getValueFromResolutionCache(String preferenceKey) {
        Optional<String> optionalBrowserVersion = Optional.empty();
        if (this.useResolutionCacheWithKey(preferenceKey)) {
            optionalBrowserVersion = Optional.of(this.resolutionCache.getValueFromResolutionCache(preferenceKey));
        }
        return optionalBrowserVersion;
    }

    protected List<File> postDownload(File archive) {
        File[] ls;
        File parentFolder = archive.getParentFile();
        for (File f : ls = parentFolder.listFiles()) {
            if (!this.getDriverName().contains(FilenameUtils.removeExtension((String)f.getName()))) continue;
            log.trace("Found driver in post-download: {}", (Object)f);
            return Collections.singletonList(f);
        }
        throw new WebDriverManagerException("Driver " + this.getDriverName() + " not found (using temporal folder " + parentFolder + ")");
    }

    protected Optional<String> getBrowserVersionFromTheShell() {
        return this.versionDetector.getBrowserVersionFromTheShell(this.getDriverManagerType().getBrowserNameLowerCase());
    }

    protected Optional<String> detectBrowserVersion() {
        Optional<String> optionalBrowserVersion;
        if (this.config().isAvoidBrowserDetection()) {
            return Optional.empty();
        }
        String driverManagerTypeLowerCase = this.getDriverManagerType().getNameLowerCase();
        if (this.useResolutionCacheWithKey(driverManagerTypeLowerCase)) {
            optionalBrowserVersion = Optional.of(this.resolutionCache.getValueFromResolutionCache(driverManagerTypeLowerCase));
            log.trace("Detected {} version {}", (Object)this.getDriverManagerType(), optionalBrowserVersion);
        } else {
            optionalBrowserVersion = this.getBrowserVersionFromTheShell();
        }
        return optionalBrowserVersion;
    }

    protected boolean useResolutionCacheWithKey(String key) {
        return this.useResolutionCache() && this.resolutionCache.checkKeyInResolutionCache(key);
    }

    protected boolean useResolutionCache() {
        return !this.config().isAvoidingResolutionCache();
    }

    protected boolean isUnknown(String driverVersion) {
        return Config.isNullOrEmpty(driverVersion) || driverVersion.equalsIgnoreCase("latest");
    }

    protected String getCurrentVersion(URL url) {
        String currentVersion = "";
        String pattern = "/([^/]*?)/[^/]*?" + this.getShortDriverName();
        Matcher matcher = Pattern.compile(pattern, 2).matcher(url.getFile());
        boolean find = matcher.find();
        if (find) {
            currentVersion = matcher.group(1);
        } else {
            log.trace("Version not found in URL {}", (Object)url);
        }
        return currentVersion;
    }

    protected void handleException(Exception e, String driverVersion) {
        String driverVersionStr = this.getDriverVersionLabel(driverVersion);
        String errorMessage = String.format("There was an error managing %s %s (%s)", this.getDriverName(), driverVersionStr, e.getMessage());
        if (this.retryCount == 0 && !this.config().isAvoidFallback()) {
            ++this.retryCount;
            if (this.getDriverManagerType() == DriverManagerType.EDGE || this.getDriverManagerType() == DriverManagerType.CHROME) {
                this.config().setAvoidReadReleaseFromRepository(true);
                this.clearResolutionCache();
                log.warn("{} ... trying again avoiding reading release from repository", (Object)errorMessage);
                this.manage("");
            } else {
                ++this.retryCount;
                this.fallback(e, errorMessage);
            }
        } else if (this.retryCount == 1 && !this.config().isAvoidFallback()) {
            this.fallback(e, errorMessage);
        } else {
            log.error("{}", (Object)errorMessage, (Object)e);
            throw new WebDriverManagerException(e);
        }
    }

    protected void fallback(Exception e, String errorMessage) {
        this.config().setAvoidBrowserDetection(true);
        String driverVersion = "";
        this.setBrowserVersion("");
        ++this.retryCount;
        log.warn("{} ... trying again using latest driver stored in cache", (Object)errorMessage);
        if (log.isTraceEnabled()) {
            log.trace("Error trace: ", (Throwable)e);
        }
        this.manage(driverVersion);
    }

    protected UrlHandler createUrlHandler(String driverVersion) throws IOException {
        boolean continueSearchingVersion;
        List<URL> candidateUrls = this.getDriverUrls();
        String shortDriverName = this.getShortDriverName();
        UrlHandler urlHandler = new UrlHandler(this.config(), candidateUrls, driverVersion, shortDriverName, this::buildUrl);
        log.trace("All driver URLs: {}", candidateUrls);
        boolean getLatest = this.isUnknown(driverVersion);
        do {
            urlHandler.filterByDriverName(shortDriverName);
            if (getLatest) {
                urlHandler.filterByLatestVersion(this::getCurrentVersion);
            } else {
                urlHandler.filterByVersion(driverVersion);
            }
            if (urlHandler.getDriverVersion() == null) break;
            log.debug("Driver to be downloaded {} {}", (Object)shortDriverName, (Object)urlHandler.getDriverVersion());
            log.trace("Driver URLs after filtering for version: {}", urlHandler.getCandidateUrls());
            String os = this.config().getOs();
            Architecture architecture = this.config().getArchitecture();
            if (architecture != Architecture.ARM64 || this.getDriverManagerType() != DriverManagerType.EDGE) {
                urlHandler.filterByOs(this.getDriverName(), os);
            }
            urlHandler.filterByArch(architecture, this.forcedArch);
            urlHandler.filterByIgnoredVersions(this.config().getIgnoreVersions());
            urlHandler.filterByBeta(this.config().isUseBetaVersions());
            boolean bl = continueSearchingVersion = urlHandler.hasNoCandidateUrl() && getLatest;
            if (!continueSearchingVersion) continue;
            log.info("No proper driver found for {} {} ... seeking another version", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
            urlHandler.resetList(candidateUrls);
            candidateUrls = urlHandler.getCandidateUrls();
        } while (continueSearchingVersion);
        return urlHandler;
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (!this.mirrorLog) {
            log.debug("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverOrigin = String.format("%s://%s", driverUrl.getProtocol(), driverUrl.getAuthority());
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(driverUrl));){
            InputStream in = response.getEntity().getContent();
            Document doc = Jsoup.parse((InputStream)in, null, (String)driverStr);
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("abs:href");
                if (link.startsWith(driverStr) && link.endsWith(SLASH)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(link)));
                    continue;
                }
                if (!link.startsWith(driverOrigin) || link.contains("icons") || !link.toLowerCase(Locale.ROOT).endsWith(".bz2") && !link.toLowerCase(Locale.ROOT).endsWith(".zip") && !link.toLowerCase(Locale.ROOT).endsWith(".gz")) continue;
                urlList.add(new URL(link));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected NamespaceContext getNamespaceContext() {
        return null;
    }

    protected Optional<NamespaceContext> getS3NamespaceContext() {
        return Optional.of(S3_NAMESPACE_CONTEXT);
    }

    protected List<URL> getDriversFromXml(URL driverUrl, String xpath, Optional<NamespaceContext> namespaceContext) throws IOException {
        this.logSeekRepo(driverUrl);
        ArrayList<URL> urls = new ArrayList<URL>();
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(driverUrl));){
            org.w3c.dom.Document xml = this.loadXML(response.getEntity().getContent());
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (namespaceContext.isPresent()) {
                xPath.setNamespaceContext(namespaceContext.get());
            }
            NodeList nodes = (NodeList)xPath.evaluate(xpath, xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl.toURI().resolve(".") + e.getChildNodes().item(0).getNodeValue()));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }

    protected void logSeekRepo(URL driverUrl) {
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
    }

    protected org.w3c.dom.Document loadXML(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream))));
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.httpClient.createHttpGet(driverUrl);
        String gitHubToken = this.config().getGitHubToken();
        if (Config.isNullOrEmpty(gitHubToken)) {
            gitHubToken = System.getenv("GITHUB_TOKEN");
        }
        if (!Config.isNullOrEmpty(gitHubToken)) {
            get.addHeader("Authorization", (Object)("token " + gitHubToken));
        }
        return this.httpClient.execute((ClassicHttpRequest)get).getEntity().getContent();
    }

    protected List<URL> getDriversFromGitHub() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        this.logSeekRepo(driverUrl);
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (mirrorUrl.isPresent() && this.config.isUseMirror()) {
            urls = this.getDriversFromMirror(mirrorUrl.get());
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected FilenameFilter getFolderFilter() {
        return (dir, name) -> dir.isDirectory() && name.toLowerCase(Locale.ROOT).contains(this.getDriverName());
    }

    protected Charset getVersionCharset() {
        return Charset.defaultCharset();
    }

    protected String getLatestVersionLabel() {
        return LATEST_RELEASE;
    }

    protected Optional<String> getOsLabel() {
        return Optional.empty();
    }

    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return this.config().isAvoidReadReleaseFromRepository() ? Optional.empty() : this.versionDetector.getDriverVersionFromRepository(driverVersion, this.getDriverUrl(), this.getVersionCharset(), this.getDriverName(), this.getLatestVersionLabel(), LATEST_RELEASE, this.getOsLabel());
    }

    protected URL getDriverUrlCkeckingMirror(URL url) {
        Optional<URL> mirrorUrl;
        if (this.config().isUseMirror() && (mirrorUrl = this.getMirrorUrl()).isPresent()) {
            return mirrorUrl.get();
        }
        return url;
    }

    protected Optional<String> getLatestDriverVersionFromRepository() {
        return Optional.empty();
    }

    protected String getShortDriverName() {
        return this.getDriverName();
    }

    protected String getKeyForResolutionCache() {
        return this.getDriverManagerType().getNameLowerCase();
    }

    protected String getDriverVersionLabel(String driverVersion) {
        return this.isUnknown(driverVersion) ? "(latest version)" : driverVersion;
    }

    protected Optional<URL> buildUrl(String driverVersion) {
        return Optional.empty();
    }

    protected WebDriver instantiateDriver() {
        WebDriver driver = null;
        try {
            String remoteAddress = this.config().getRemoteAddress();
            if (this.dockerEnabled) {
                driver = this.createDockerWebDriver();
            } else if (!Config.isNullOrEmpty(remoteAddress)) {
                Capabilities caps = Optional.ofNullable(this.capabilities).orElse(this.getCapabilities());
                driver = this.webDriverCreator.createRemoteWebDriver(remoteAddress, caps);
                this.webDriverList.add(new WebDriverBrowser(driver));
            } else {
                driver = this.createLocalWebDriver();
            }
        }
        catch (Exception e) {
            log.error("There was an error creating WebDriver object for {}", (Object)this.getDriverManagerType().getBrowserName(), (Object)e);
        }
        this.addShutdownHookIfRequired();
        return driver;
    }

    protected Capabilities getMergedCapabilities() {
        Capabilities caps = this.getCapabilities();
        if (this.capabilities != null) {
            caps = caps.merge(this.capabilities);
        }
        return caps;
    }

    protected void addShutdownHookIfRequired() {
        if (!this.shutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread("wdm-shutdown-hook"){

                @Override
                public void run() {
                    try {
                        WebDriverManager.this.quit();
                    }
                    catch (Exception e) {
                        log.warn("Exception in wdm-shutdown-hook ({})", (Object)e.getMessage());
                    }
                }
            });
            this.shutdownHook = true;
        }
    }

    protected WebDriver createDockerWebDriver() {
        String browserImage;
        String browserName = this.getKeyForResolutionCache();
        if (this.androidEnabled) {
            browserName = browserName + "-mobile";
        }
        String browserVersion = this.getBrowserVersion();
        String browserCacheKey = browserName + "-container-";
        String dockerCustomImage = this.config().getDockerCustomImage();
        if (!Config.isNullOrEmpty(dockerCustomImage)) {
            browserImage = dockerCustomImage;
            browserVersion = this.dockerService.getVersionFromImage(browserImage);
            browserCacheKey = browserCacheKey + "custom";
        } else {
            if (this.isUnknown(browserVersion) || this.dockerService.isBrowserVersionLatesMinus(browserVersion)) {
                browserCacheKey = browserCacheKey + (Config.isNullOrEmpty(browserVersion) ? "latest" : browserVersion);
                browserVersion = this.dockerService.getImageVersionFromDockerHub(this.getDriverManagerType(), browserCacheKey, browserName, browserVersion, this.androidEnabled);
            } else {
                if (!this.dockerService.isBrowserVersionWildCard(browserVersion) && !browserVersion.contains(".")) {
                    browserVersion = browserVersion + ".0";
                }
                browserCacheKey = browserCacheKey + browserVersion;
            }
            browserImage = this.dockerService.getDockerImage(browserName, browserVersion, this.androidEnabled);
        }
        DockerContainer browserContainer = this.dockerService.startBrowserContainer(browserImage, browserCacheKey, browserVersion, this.androidEnabled);
        browserContainer.setBrowserName(browserName);
        String seleniumServerUrl = browserContainer.getContainerUrl();
        WebDriverBrowser driverBrowser = new WebDriverBrowser();
        driverBrowser.addDockerContainer(browserContainer);
        driverBrowser.setSeleniumServerUrl(seleniumServerUrl);
        log.trace("The Selenium Serverl URL is {}", (Object)seleniumServerUrl);
        driverBrowser.setBrowserContainerId(browserContainer.getContainerId());
        this.webDriverList.add(driverBrowser);
        WebDriver driver = this.webDriverCreator.createRemoteWebDriver(seleniumServerUrl, this.getMergedCapabilities());
        driverBrowser.setDriver(driver);
        String sessionId = this.webDriverCreator.getSessionId(driverBrowser.getDriver());
        browserContainer.setSessionId(sessionId);
        if (this.config.isEnabledDockerVnc()) {
            String noVncImage = this.config.getDockerNoVncImage();
            String noVncVersion = this.dockerService.getVersionFromImage(noVncImage);
            DockerContainer noVncContainer = this.dockerService.startNoVncContainer(noVncImage, "novnc-container", noVncVersion, browserContainer);
            driverBrowser.addDockerContainer(noVncContainer);
            String noVncUrl = noVncContainer.getContainerUrl();
            driverBrowser.setNoVncUrl(noVncUrl);
            log.info("Docker session noVNC URL: {}", (Object)noVncUrl);
        }
        if (this.config.isEnabledDockerRecording()) {
            String recorderImage = this.config.getDockerRecordingImage();
            String recorderVersion = this.dockerService.getVersionFromImage(recorderImage);
            DockerContainer recorderContainer = this.dockerService.startRecorderContainer(recorderImage, "recorder-container", recorderVersion, browserContainer);
            driverBrowser.addDockerContainer(recorderContainer, 0);
            Path recordingPath = recorderContainer.getRecordingPath();
            driverBrowser.setRecordingPath(recordingPath);
            log.info("Starting recording {}", (Object)recordingPath);
        }
        return driverBrowser.getDriver();
    }

    protected WebDriver createLocalWebDriver() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        WebDriver driver = null;
        if (this.getDriverManagerType() != null) {
            if (this.getDriverManagerType() == DriverManagerType.CHROMIUM) {
                this.capabilities = this.getCapabilities();
            }
            Class<?> browserClass = Class.forName(this.getDriverManagerType().browserClass());
            driver = this.webDriverCreator.createLocalWebDriver(browserClass, this.capabilities);
            this.webDriverList.add(new WebDriverBrowser(driver));
        }
        return driver;
    }

    protected Capabilities getCapabilities() {
        return new MutableCapabilities();
    }

    protected void addDefaultArgumentsForDocker(Capabilities options) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (this.dockerEnabled && !this.androidEnabled) {
            Method addArgumentsMethod = options.getClass().getMethod("addArguments", List.class);
            List<String> defaultArgs = Arrays.asList(this.config.getDockerDefaultArgs().split(","));
            addArgumentsMethod.invoke((Object)options, defaultArgs);
        }
    }

    protected static void logCliError(String browserForResolving, String browserForDocker, int port) {
        log.error("The valid arguments for WebDriverManager CLI are:");
        log.error("1. For resolving drivers locally:");
        log.error("\t{} browserName <driverVersion>", (Object)CLI_RESOLVER);
        log.error("(where browserName is: {})", (Object)browserForResolving);
        log.error("");
        log.error("2. For running a browser in a Docker (and use it trough noVNC):");
        log.error("\t{} browserName <browserVersion>", (Object)CLI_DOCKER);
        log.error("(where browserName is: {})", (Object)browserForDocker);
        log.error("");
        log.error("3. For starting WebDriverManager Server:");
        log.error("\t{} <port>", (Object)CLI_SERVER);
        log.error("(where the default port is {})", (Object)port);
    }

    protected static void resolveLocal(String[] args, String validBrowsers) {
        String browserName = args[1];
        log.info("Using WebDriverManager to resolve {}", (Object)browserName);
        try {
            WebDriverManager wdm = WebDriverManager.getInstance(browserName).avoidExport().cachePath(".").forceDownload().avoidResolutionCache();
            if (browserName.equalsIgnoreCase("iexplorer")) {
                wdm.operatingSystem(OperatingSystem.WIN);
            }
            if (args.length > 2) {
                wdm.driverVersion(args[2]);
            }
            if (SystemUtils.IS_OS_LINUX && wdm.getDockerService().isRunningInsideDocker()) {
                wdm.avoidBrowserDetection();
            }
            wdm.avoidOutputTree().setup();
        }
        catch (Exception e) {
            log.error("Driver for {} not found (valid browsers {})", (Object)browserName, (Object)validBrowsers);
        }
    }

    protected static void runInDocker(String[] args, String validBrowsers) {
        String browserName = args[1];
        log.info("Using WebDriverManager to run {} in Docker", (Object)browserName);
        try {
            WebDriverManager wdm = browserName.equalsIgnoreCase("chrome-mobile") ? WebDriverManager.chromedriver().browserInDockerAndroid() : WebDriverManager.getInstance(browserName).browserInDocker();
            if (args.length > 2) {
                wdm.browserVersion(args[2]);
            }
            wdm.enableVnc().avoidResolutionCache().create();
            log.info("Press ENTER to exit");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
            scanner.close();
            wdm.quit();
        }
        catch (Exception e) {
            log.error("Browser {} not available in Docker (valid browsers {})", (Object)browserName, (Object)validBrowsers);
        }
    }

    protected static void startServer(String[] args, int port) {
        if (args.length > 1 && StringUtils.isNumeric((String)args[1])) {
            port = Integer.parseInt(args[1]);
        }
        new WdmServer(port);
    }

    public static void main(String[] args) {
        String browserForResolving = "chrome|edge|firefox|opera|chromium|iexplorer";
        String browserForNoVnc = "chrome|edge|firefox|opera|safari|chrome-mobile";
        int port = new Config().getServerPort();
        int numArgs = args.length;
        if (numArgs <= 0) {
            WebDriverManager.logCliError(browserForResolving, browserForNoVnc, port);
        } else {
            String arg = args[0].toLowerCase(Locale.ROOT);
            if (arg.equalsIgnoreCase(CLI_SERVER)) {
                WebDriverManager.startServer(args, port);
            } else if (arg.equalsIgnoreCase(CLI_RESOLVER) && numArgs > 1) {
                WebDriverManager.resolveLocal(args, browserForResolving);
            } else if (arg.equalsIgnoreCase(CLI_DOCKER) && numArgs > 1) {
                WebDriverManager.runInDocker(args, browserForNoVnc);
            } else {
                WebDriverManager.logCliError(browserForResolving, browserForNoVnc, port);
            }
        }
    }
}

