/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.DeflateInputStreamFactory;
import org.apache.hc.client5.http.entity.GZIPInputStreamFactory;
import org.apache.hc.client5.http.entity.InputStreamFactory;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.brotli.dec.BrotliInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    CloseableHttpClient closeableHttpClient;

    public HttpClient(Config config) {
        this.config = config;
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManagerShared(true);
        try {
            this.setupProxyIfRequired(builder);
            HostnameVerifier allHostsValid = (hostname, session) -> hostname.equalsIgnoreCase(session.getPeerHost());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, allHostsValid);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            LinkedHashMap<String, 2> contentDecoderMap = new LinkedHashMap<String, 2>();
            contentDecoderMap.put("br", new InputStreamFactory(){

                public InputStream create(InputStream inStream) throws IOException {
                    return new BrotliInputStream(inStream);
                }
            });
            contentDecoderMap.put("gzip", GZIPInputStreamFactory.getInstance());
            contentDecoderMap.put("x-gzip", GZIPInputStreamFactory.getInstance());
            contentDecoderMap.put("deflate", DeflateInputStreamFactory.getInstance());
            builder.setContentDecoderRegistry(contentDecoderMap);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        this.closeableHttpClient = builder.useSystemProperties().build();
    }

    public HttpGet createHttpGet(URL url) {
        HttpGet httpGet = new HttpGet(url.toString());
        httpGet.addHeader("user-agent", (Object)"Apache-HttpClient/5.0");
        httpGet.addHeader("accept-encoding", (Object)"gzip, deflate, br");
        httpGet.addHeader("cache-control", (Object)"max-age=0");
        httpGet.addHeader("connection", (Object)"keep-alive");
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("strict").setConnectTimeout((long)this.config.getTimeout(), TimeUnit.SECONDS).build();
        httpGet.setConfig(requestConfig);
        return httpGet;
    }

    public CloseableHttpResponse execute(ClassicHttpRequest method) throws IOException {
        CloseableHttpResponse response = this.closeableHttpClient.execute(method);
        int responseCode = response.getCode();
        if (responseCode >= 400) {
            String methodUri = "";
            try {
                methodUri = method.getUri().toString();
            }
            catch (Exception e) {
                this.log.trace("Exception reading URI from method: {}", (Object)e.getMessage());
            }
            String errorMessage = "Error HTTP " + responseCode + " executing " + methodUri;
            this.log.error(errorMessage);
            throw new WebDriverManagerException(errorMessage);
        }
        return response;
    }

    private void setupProxyIfRequired(HttpClientBuilder builder) throws MalformedURLException, UnsupportedEncodingException {
        String proxy = this.config.getProxy();
        Optional<HttpHost> proxyHost = this.createProxyHttpHost(proxy);
        if (proxyHost.isPresent()) {
            builder.setProxy(proxyHost.get());
            Optional<BasicCredentialsProvider> credentialsProvider = this.createBasicCredentialsProvider(proxy, this.config.getProxyUser(), this.config.getProxyPass(), proxyHost.get());
            if (credentialsProvider.isPresent()) {
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider.get());
            }
        }
    }

    private Optional<Proxy> createProxy(String proxy) throws MalformedURLException {
        Optional<URL> url = this.determineProxyUrl(proxy);
        if (url.isPresent()) {
            String proxyHost = url.get().getHost();
            int proxyPort = url.get().getPort() == -1 ? 80 : url.get().getPort();
            return Optional.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return Optional.empty();
    }

    private Optional<URL> determineProxyUrl(String proxy) throws MalformedURLException {
        String proxyInput;
        String proxyFromEnvCaps = System.getenv("HTTPS_PROXY");
        String proxyFromEnv = Config.isNullOrEmpty(proxyFromEnvCaps) ? System.getenv("https_proxy") : proxyFromEnvCaps;
        String string = proxyInput = Config.isNullOrEmpty(proxy) ? proxyFromEnv : proxy;
        if (!Config.isNullOrEmpty(proxyInput)) {
            return Optional.of(new URL((String)(proxyInput.matches("^http[s]?://.*$") ? proxyInput : "http://" + proxyInput)));
        }
        return Optional.empty();
    }

    private final Optional<HttpHost> createProxyHttpHost(String proxyUrl) throws MalformedURLException {
        Optional<Proxy> proxy = this.createProxy(proxyUrl);
        if (proxy.isPresent() && proxy.get().address() != null) {
            if (!(proxy.get().address() instanceof InetSocketAddress)) {
                String errorMessage = "Detect an unsupported subclass of SocketAddress. Please use the InetSocketAddress or subclass. Actual:" + proxy.get().address().getClass();
                this.log.error(errorMessage);
                throw new WebDriverManagerException(errorMessage);
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.get().address();
            return Optional.of(new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort()));
        }
        return Optional.empty();
    }

    private final Optional<BasicCredentialsProvider> createBasicCredentialsProvider(String proxy, String proxyUser, String proxyPass, HttpHost proxyHost) throws MalformedURLException, UnsupportedEncodingException {
        Optional<URL> proxyUrl = this.determineProxyUrl(proxy);
        if (!proxyUrl.isPresent()) {
            return Optional.empty();
        }
        String username = null;
        String password = null;
        String userInfo = proxyUrl.get().getUserInfo();
        if (userInfo != null) {
            StringTokenizer st = new StringTokenizer(userInfo, ":");
            username = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
            password = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
        }
        String envProxyUser = System.getenv("HTTPS_PROXY_USER");
        String envProxyPass = System.getenv("HTTPS_PROXY_PASS");
        username = envProxyUser != null ? envProxyUser : username;
        password = envProxyPass != null ? envProxyPass : password;
        username = Config.isNullOrEmpty(proxyUser) ? username : proxyUser;
        String string = password = Config.isNullOrEmpty(proxyPass) ? password : proxyPass;
        if (username == null) {
            return Optional.empty();
        }
        String ntlmUsername = username;
        String ntlmDomain = null;
        int index = username.indexOf(92);
        if (index > 0) {
            ntlmDomain = username.substring(0, index);
            ntlmUsername = username.substring(index + 1);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(proxyHost, null, "NTLM");
        char[] passwd = password == null ? new char[]{} : password.toCharArray();
        NTCredentials creds = new NTCredentials(ntlmUsername, passwd, this.getWorkstation(), ntlmDomain);
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort());
        creds = new UsernamePasswordCredentials(username, passwd);
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        return Optional.of(credentialsProvider);
    }

    private String getWorkstation() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeableHttpClient.close();
    }
}

