/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.webdriver.OptionsWithArguments;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.edge.EdgeOptions;

public class EdgeDriverManager
extends WebDriverManager {
    protected static final String LATEST_STABLE = "LATEST_STABLE";

    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.EDGE;
    }

    @Override
    protected String getDriverName() {
        return "msedgedriver";
    }

    @Override
    protected String getShortDriverName() {
        return "edgedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getEdgeDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getEdgeVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setEdgeDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setEdgeVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.config().getEdgeDriverUrl();
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getEdgeDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setEdgeDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        return this.getDriversFromXml(new URL(this.getDriverUrl() + "?restype=container&comp=list"), "//Blob/Name", Optional.empty());
    }

    @Override
    protected List<File> postDownload(File archive) {
        Collection listFiles = FileUtils.listFiles((File)new File(archive.getParent()), null, (boolean)true);
        Iterator iterator = listFiles.iterator();
        File file = null;
        ArrayList<File> files = new ArrayList<File>();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            String fileName = file.getName();
            if (fileName.contains(this.getDriverName())) {
                log.trace("Adding {} at the begining of the resulting file list", (Object)fileName);
                files.add(0, file);
                continue;
            }
            if (!fileName.toLowerCase(Locale.ROOT).endsWith(".dylib")) continue;
            log.trace("Adding {} to the resulting file list", (Object)fileName);
            files.add(file);
        }
        return files;
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions() || this.config().isAvoidReadReleaseFromRepository()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected Charset getVersionCharset() {
        return StandardCharsets.UTF_16;
    }

    @Override
    protected String getLatestVersionLabel() {
        return LATEST_STABLE;
    }

    @Override
    protected Optional<String> getOsLabel() {
        Object label = "_";
        switch (this.config().getOperatingSystem()) {
            case WIN: {
                label = (String)label + "WINDOWS";
                break;
            }
            case MAC: {
                label = (String)label + "MACOS";
                break;
            }
            default: {
                label = (String)label + this.config().getOs();
            }
        }
        return Optional.of(label);
    }

    @Override
    protected Optional<URL> buildUrl(String driverVersion) {
        Optional<URL> optionalUrl = Optional.empty();
        if (!this.config().isUseMirror()) {
            String downloadUrlPattern = this.config().getEdgeDownloadUrlPattern();
            OperatingSystem os = this.config().getOperatingSystem();
            Architecture arch = this.config().getArchitecture();
            String archLabel = os.isWin() ? arch.toString() : "64";
            String osName = arch != Architecture.ARM64 ? os.getName() : "arm";
            String builtUrl = String.format(downloadUrlPattern, driverVersion, osName, archLabel);
            log.debug("Using URL built from repository pattern: {}", (Object)builtUrl);
            try {
                optionalUrl = Optional.of(new URL(builtUrl));
            }
            catch (MalformedURLException e) {
                log.warn("Error building URL from pattern {} {}", (Object)builtUrl, (Object)e.getMessage());
            }
        }
        return optionalUrl;
    }

    @Override
    protected Capabilities getCapabilities() {
        Object options = new EdgeOptions();
        try {
            this.addDefaultArgumentsForDocker((Capabilities)options);
        }
        catch (Exception e) {
            log.error("Exception adding default arguments for Docker, retyring with custom class");
            options = new OptionsWithArguments("MicrosoftEdge", "ms:edgeOptions");
            try {
                this.addDefaultArgumentsForDocker((Capabilities)options);
            }
            catch (Exception e1) {
                log.error("Exception getting default capabilities", (Throwable)e);
            }
        }
        return options;
    }

    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setEdgeDriverExport(exportParameter);
        return this;
    }
}

