/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class FirefoxDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.FIREFOX;
    }

    @Override
    protected String getDriverName() {
        return "geckodriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getGeckoDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getFirefoxVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setGeckoDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setFirefoxVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getFirefoxDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getFirefoxDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getFirefoxDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setFirefoxDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url) {
        String currentVersion = url.getFile().substring(url.getFile().indexOf(45) + 1, url.getFile().lastIndexOf(45));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected Optional<String> getBrowserVersionFromTheShell() {
        String[] programFilesEnvs = new String[]{this.getProgramFilesEnv(), this.getOtherProgramFilesEnv()};
        String[] winBrowserNames = new String[]{"\\\\Mozilla Firefox\\\\firefox.exe"};
        return this.versionDetector.getDefaultBrowserVersion(programFilesEnvs, winBrowserNames, "firefox", "/Applications/Firefox.app/Contents/MacOS/firefox", "-v");
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }
}

