/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.versions;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.versions.Shell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDetector {
    static final String REG_SZ = "REG_SZ";
    static final String ONLINE = "online";
    static final String LOCAL = "local";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Config config;
    HttpClient httpClient;
    Properties versionsProperties;
    boolean isSnap;

    public VersionDetector(Config config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public Optional<String> getDriverVersionFromProperties(String key) {
        boolean online;
        if (key.contains("chromium")) {
            key = key.replace("chromium", "chrome");
        }
        String onlineMessage = (online = this.config.getVersionsPropertiesOnlineFirst()) ? ONLINE : LOCAL;
        this.log.debug("Getting driver version for {} from {} versions.properties", (Object)key, (Object)onlineMessage);
        String value = this.getVersionFromProperties(online).getProperty(key);
        if (value == null) {
            String notOnlineMessage = online ? LOCAL : ONLINE;
            this.log.debug("Driver for {} not found in {} properties (using {} version.properties)", new Object[]{key, onlineMessage, notOnlineMessage});
            this.versionsProperties = null;
            value = this.getVersionFromProperties(!online).getProperty(key);
        }
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public Properties getVersionFromProperties(boolean online) {
        if (this.versionsProperties != null) {
            this.log.trace("Already created versions.properties");
            return this.versionsProperties;
        }
        try (InputStream inputStream = this.getVersionsInputStream(online);){
            this.versionsProperties = new Properties();
            this.versionsProperties.load(inputStream);
        }
        catch (Exception e) {
            this.versionsProperties = null;
            throw new IllegalStateException("Cannot read versions.properties", e);
        }
        return this.versionsProperties;
    }

    public InputStream getVersionsInputStream(boolean online) throws IOException {
        InputStream inputStream;
        String onlineMessage = online ? ONLINE : LOCAL;
        this.log.trace("Reading {} version.properties to find out driver version", (Object)onlineMessage);
        try {
            inputStream = online ? this.getOnlineVersionsInputStream() : this.getLocalVersionsInputStream();
        }
        catch (Exception e) {
            String exceptionMessage = online ? LOCAL : ONLINE;
            this.log.warn("Error reading version.properties, using {} instead", (Object)exceptionMessage);
            inputStream = online ? this.getLocalVersionsInputStream() : this.getOnlineVersionsInputStream();
        }
        return inputStream;
    }

    public InputStream getLocalVersionsInputStream() {
        InputStream inputStream = Config.class.getResourceAsStream("/versions.properties");
        return inputStream;
    }

    public InputStream getOnlineVersionsInputStream() throws IOException {
        return this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(this.config.getVersionsPropertiesUrl())).getEntity().getContent();
    }

    public Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion, URL driverUrl, Charset versionCharset, String driverName, String versionLabel, String latestLabel) {
        String url = driverVersion.isPresent() ? driverUrl + latestLabel + "_" + driverVersion.get() : driverUrl + versionLabel;
        Optional<String> result = Optional.empty();
        try (InputStream response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(new URL(url))).getEntity().getContent();){
            result = Optional.of(IOUtils.toString((InputStream)response, (Charset)versionCharset).replace("\r\n", ""));
        }
        catch (Exception e) {
            this.log.warn("Exception reading {} to get latest version of {} ({})", new Object[]{url, driverName, e.getMessage()});
        }
        if (result.isPresent()) {
            this.log.debug("Latest version of {} according to {} is {}", new Object[]{driverName, url, result.get()});
        }
        return result;
    }

    public Optional<String> getDefaultBrowserVersion(String[] programFilesEnvs, String[] winBrowserNames, String linuxBrowserName, String macBrowserName, String versionFlag, String browserNameInOutput) {
        String browserPath = this.config.getBrowserPath();
        if (SystemUtils.IS_OS_WINDOWS) {
            String winName = "";
            for (int j = 0; j < winBrowserNames.length; ++j) {
                winName = winBrowserNames[j];
                for (int i = 0; i < programFilesEnvs.length; ++i) {
                    String browserVersionOutput = this.getBrowserVersionInWindows(programFilesEnvs[i], winName, browserPath);
                    if (Config.isNullOrEmpty(browserVersionOutput)) continue;
                    return Optional.of(Shell.getVersionFromWmicOutput(browserVersionOutput));
                }
            }
        } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            String browserVersionOutput = Shell.runAndWait(browserPath = this.getPosixBrowserPath(linuxBrowserName, macBrowserName, browserPath), versionFlag);
            if (browserVersionOutput.toLowerCase().contains("snap")) {
                this.isSnap = true;
            }
            if (!Config.isNullOrEmpty(browserVersionOutput)) {
                return Optional.of(Shell.getVersionFromPosixOutput(browserVersionOutput, browserNameInOutput));
            }
        }
        return Optional.empty();
    }

    public String getPosixBrowserPath(String linuxBrowserName, String macBrowserName, String browserPath) {
        if (!Config.isNullOrEmpty(browserPath)) {
            return browserPath;
        }
        return SystemUtils.IS_OS_LINUX ? linuxBrowserName : macBrowserName;
    }

    public String getBrowserVersionInWindows(String programFilesEnv, String winBrowserName, String browserPath) {
        String programFiles = System.getenv(programFilesEnv).replace("\\", "\\\\");
        String fullBrowserPath = Config.isNullOrEmpty(browserPath) ? programFiles + winBrowserName : browserPath;
        String wmic = "wmic.exe";
        return Shell.runAndWait(this.findFileLocation(wmic), wmic, "datafile", "where", "name='" + fullBrowserPath + "'", "get", "Version", "/value");
    }

    public Optional<String> getBrowserVersionFromWinRegistry(String key, String value) {
        Optional<String> browserVersionFromRegistry = Optional.empty();
        String regQueryResult = Shell.runAndWait("REG", "QUERY", key, "/v", value);
        int i = regQueryResult.indexOf(REG_SZ);
        int j = regQueryResult.indexOf(46, i);
        if (i != -1 && j != -1) {
            browserVersionFromRegistry = Optional.of(regQueryResult.substring(i + REG_SZ.length(), j).trim());
        }
        return browserVersionFromRegistry;
    }

    public File findFileLocation(String filename) {
        File system32File;
        File system32Folder = new File(System.getenv("SystemRoot"), "System32");
        if (this.checkFileAndFolder(system32Folder, system32File = new File(system32Folder, filename))) {
            return system32Folder;
        }
        File wbemFolder = new File(system32Folder, "wbem");
        File wbemFile = new File(wbemFolder, filename);
        if (this.checkFileAndFolder(wbemFolder, wbemFile)) {
            return wbemFolder;
        }
        return new File(".");
    }

    public boolean checkFileAndFolder(File folder, File file) {
        return folder.exists() && folder.isDirectory() && file.exists() && file.isFile();
    }

    public boolean isSnap() {
        return this.isSnap;
    }
}

