/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class FirefoxDriverManager
extends WebDriverManager {
    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.FIREFOX;
    }

    @Override
    protected String getDriverName() {
        return "geckodriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getGeckoDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getFirefoxVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setGeckoDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setFirefoxVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getFirefoxDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getFirefoxDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getFirefoxDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setFirefoxDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url) {
        String currentVersion = url.getFile().substring(url.getFile().indexOf(45) + 1, url.getFile().lastIndexOf(45));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String driverVersion) {
        int iSeparator = target.indexOf(driverVersion) - 1;
        int iDash = target.lastIndexOf(driverVersion) + driverVersion.length();
        int iPoint = target.lastIndexOf(".zip");
        int iPointTazGz = target.lastIndexOf(".tar.gz");
        int iPointGz = target.lastIndexOf(".gz");
        if (iPointTazGz != -1) {
            iPoint = iPointTazGz;
        } else if (iPointGz != -1) {
            iPoint = iPointGz;
        }
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        return target;
    }

    @Override
    protected Optional<String> getBrowserVersionFromTheShell() {
        String[] programFilesEnvs = new String[]{this.getProgramFilesEnv(), this.getOtherProgramFilesEnv()};
        String[] winBrowserNames = new String[]{"\\\\Mozilla Firefox\\\\firefox.exe"};
        return this.versionDetector.getDefaultBrowserVersion(programFilesEnvs, winBrowserNames, "firefox", "/Applications/Firefox.app/Contents/MacOS/firefox", "-v", this.getDriverManagerType().toString());
    }

    @Override
    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return Optional.empty();
    }
}

