/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String TTL = "-ttl";
    java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(WebDriverManager.class);
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Config config;

    public Preferences(Config config) {
        this.config = config;
    }

    public String getValueFromPreferences(String key) {
        return this.prefs.get(key, null);
    }

    private long getExpirationTimeFromPreferences(String key) {
        return this.prefs.getLong(this.getExpirationKey(key), 0L);
    }

    public void putValueInPreferencesIfEmpty(String key, String value) {
        if (this.getValueFromPreferences(key) == null) {
            this.prefs.put(key, value);
            long expirationTime = new Date().getTime() + TimeUnit.SECONDS.toMillis(this.config.getTtl());
            this.prefs.putLong(this.getExpirationKey(key), expirationTime);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing preference {}={} (valid until {})", new Object[]{key, value, this.formatTime(expirationTime)});
            }
        }
    }

    private void clearFromPreferences(String key) {
        this.prefs.remove(key);
        this.prefs.remove(this.getExpirationKey(key));
    }

    public void clear() {
        try {
            this.log.info("Clearing WebDriverManager preferences");
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            this.log.warn("Exception clearing preferences", (Throwable)e);
        }
    }

    private boolean checkValidity(String key, String value, long expirationTime) {
        boolean isValid;
        long now = new Date().getTime();
        boolean bl = isValid = value != null && expirationTime != 0L && expirationTime > now;
        if (!isValid) {
            String expirationDate = this.formatTime(expirationTime);
            this.log.debug("Removing preference {}={} (expired on {})", new Object[]{key, value, expirationDate});
            this.clearFromPreferences(key);
        }
        return isValid;
    }

    private String formatTime(long time) {
        return this.dateFormat.format(new Date(time));
    }

    private String getExpirationKey(String key) {
        return key + TTL;
    }

    public boolean checkKeyInPreferences(String key) {
        boolean valueInPreferences;
        String valueFromPreferences = this.getValueFromPreferences(key);
        boolean bl = valueInPreferences = valueFromPreferences != null && !valueFromPreferences.isEmpty();
        if (valueInPreferences) {
            long expirationTime = this.getExpirationTimeFromPreferences(key);
            String expirationDate = this.formatTime(expirationTime);
            if (valueInPreferences &= this.checkValidity(key, valueFromPreferences, expirationTime)) {
                this.log.debug("Preference {}={} (valid until {})", new Object[]{key, valueFromPreferences, expirationDate});
            }
        }
        return valueInPreferences;
    }
}

