/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.ConfigKey;
import io.github.bonigarcia.wdm.OperatingSystem;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String HOME = "~";
    ConfigKey<String> properties = new ConfigKey<String>("wdm.properties", String.class, "webdrivermanager.properties");
    ConfigKey<String> targetPath = new ConfigKey<String>("wdm.targetPath", String.class);
    ConfigKey<Boolean> forceCache = new ConfigKey<Boolean>("wdm.forceCache", Boolean.class);
    ConfigKey<Boolean> override = new ConfigKey<Boolean>("wdm.override", Boolean.class);
    ConfigKey<Boolean> useMirror = new ConfigKey<Boolean>("wdm.useMirror", Boolean.class);
    ConfigKey<Boolean> useBetaVersions = new ConfigKey<Boolean>("wdm.useBetaVersions", Boolean.class);
    ConfigKey<Boolean> avoidExport = new ConfigKey<Boolean>("wdm.avoidExport", Boolean.class);
    ConfigKey<Boolean> avoidOutputTree = new ConfigKey<Boolean>("wdm.avoidOutputTree", Boolean.class);
    ConfigKey<Boolean> avoidAutoVersion = new ConfigKey<Boolean>("wdm.avoidAutoVersion", Boolean.class);
    ConfigKey<Boolean> avoidAutoReset = new ConfigKey<Boolean>("wdm.avoidAutoReset", Boolean.class);
    ConfigKey<Boolean> avoidPreferences = new ConfigKey<Boolean>("wdm.avoidPreferences", Boolean.class);
    ConfigKey<Integer> timeout = new ConfigKey<Integer>("wdm.timeout", Integer.class);
    ConfigKey<URL> versionsPropertiesUrl = new ConfigKey<URL>("wdm.versionsPropertiesUrl", URL.class);
    ConfigKey<String> architecture = new ConfigKey<String>("wdm.architecture", String.class, this.defaultArchitecture());
    ConfigKey<String> os = new ConfigKey<String>("wdm.os", String.class, this.defaultOsName());
    ConfigKey<String> proxy = new ConfigKey<String>("wdm.proxy", String.class);
    ConfigKey<String> proxyUser = new ConfigKey<String>("wdm.proxyUser", String.class);
    ConfigKey<String> proxyPass = new ConfigKey<String>("wdm.proxyPass", String.class);
    ConfigKey<String> ignoreVersions = new ConfigKey<String>("wdm.ignoreVersions", String.class);
    ConfigKey<String> gitHubTokenName = new ConfigKey<String>("wdm.gitHubTokenName", String.class);
    ConfigKey<String> gitHubTokenSecret = new ConfigKey<String>("wdm.gitHubTokenSecret", String.class);
    ConfigKey<String> chromeDriverVersion = new ConfigKey<String>("wdm.chromeDriverVersion", String.class);
    ConfigKey<String> chromeDriverExport = new ConfigKey<String>("wdm.chromeDriverExport", String.class);
    ConfigKey<URL> chromeDriverUrl = new ConfigKey<URL>("wdm.chromeDriverUrl", URL.class);
    ConfigKey<URL> chromeDriverMirrorUrl = new ConfigKey<URL>("wdm.chromeDriverMirrorUrl", URL.class);
    ConfigKey<String> edgeDriverVersion = new ConfigKey<String>("wdm.edgeDriverVersion", String.class);
    ConfigKey<String> edgeDriverExport = new ConfigKey<String>("wdm.edgeDriverExport", String.class);
    ConfigKey<URL> edgeDriverUrl = new ConfigKey<URL>("wdm.edgeDriverUrl", URL.class);
    ConfigKey<String> firefoxDriverVersion = new ConfigKey<String>("wdm.geckoDriverVersion", String.class);
    ConfigKey<String> firefoxDriverExport = new ConfigKey<String>("wdm.geckoDriverExport", String.class);
    ConfigKey<URL> firefoxDriverUrl = new ConfigKey<URL>("wdm.geckoDriverUrl", URL.class);
    ConfigKey<URL> firefoxDriverMirrorUrl = new ConfigKey<URL>("wdm.geckoDriverMirrorUrl", URL.class);
    ConfigKey<String> internetExplorerDriverVersion = new ConfigKey<String>("wdm.internetExplorerDriverVersion", String.class);
    ConfigKey<String> internetExplorerDriverExport = new ConfigKey<String>("wdm.internetExplorerDriverExport", String.class);
    ConfigKey<URL> internetExplorerDriverUrl = new ConfigKey<URL>("wdm.internetExplorerDriverUrl", URL.class);
    ConfigKey<String> operaDriverVersion = new ConfigKey<String>("wdm.operaDriverVersion", String.class);
    ConfigKey<String> operaDriverExport = new ConfigKey<String>("wdm.operaDriverExport", String.class);
    ConfigKey<URL> operaDriverUrl = new ConfigKey<URL>("wdm.operaDriverUrl", URL.class);
    ConfigKey<URL> operaDriverMirrorUrl = new ConfigKey<URL>("wdm.operaDriverMirrorUrl", URL.class);
    ConfigKey<String> phantomjsDriverVersion = new ConfigKey<String>("wdm.phantomjsDriverVersion", String.class);
    ConfigKey<String> phantomjsDriverExport = new ConfigKey<String>("wdm.phantomjsDriverExport", String.class);
    ConfigKey<URL> phantomjsDriverUrl = new ConfigKey<URL>("wdm.phantomjsDriverUrl", URL.class);
    ConfigKey<URL> phantomjsDriverMirrorUrl = new ConfigKey<URL>("wdm.phantomjsDriverMirrorUrl", URL.class);
    ConfigKey<String> seleniumServerStandaloneVersion = new ConfigKey<String>("wdm.seleniumServerStandaloneVersion", String.class);
    ConfigKey<URL> seleniumServerStandaloneUrl = new ConfigKey<URL>("wdm.seleniumServerStandaloneUrl", URL.class);
    ConfigKey<Integer> serverPort = new ConfigKey<Integer>("wdm.serverPort", Integer.class);
    ConfigKey<String> binaryPath = new ConfigKey<String>("wdm.binaryPath", String.class);
    ConfigKey<Integer> ttl = new ConfigKey<Integer>("wdm.ttl", Integer.class);

    private <T> T resolve(ConfigKey<T> configKey) {
        String name = configKey.getName();
        T tValue = configKey.getValue();
        Class<T> type = configKey.getType();
        return this.resolver(name, tValue, type);
    }

    private <T> T resolver(String name, T tValue, Class<T> type) {
        String strValue = System.getenv(name.toUpperCase().replace(".", "_"));
        if (strValue == null) {
            strValue = System.getProperty(name);
        }
        if (strValue == null && tValue != null) {
            return tValue;
        }
        if (strValue == null) {
            strValue = this.getProperty(name);
        }
        return this.parse(type, strValue);
    }

    private <T> T parse(Class<T> type, String strValue) {
        Object output = null;
        if (type.equals(String.class)) {
            output = strValue;
        } else if (type.equals(Integer.class)) {
            output = Integer.valueOf(strValue);
        } else if (type.equals(Boolean.class)) {
            output = Boolean.valueOf(strValue);
        } else if (type.equals(URL.class)) {
            try {
                output = new URL(strValue);
            }
            catch (Exception e) {
                throw new WebDriverManagerException(e);
            }
        } else {
            throw new WebDriverManagerException("Type " + type.getTypeName() + " cannot be parsed");
        }
        return (T)output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProperty(String key) {
        String value = null;
        String propertiesValue = "/" + this.getProperties();
        String defaultProperties = "/webdrivermanager.properties";
        try {
            value = this.getPropertyFrom(propertiesValue, key);
            if (value == null) {
                this.log.trace("Property {} not found in {}, using default values (in {})", new Object[]{key, propertiesValue, defaultProperties});
                value = this.getPropertyFrom(defaultProperties, key);
            }
        }
        finally {
            if (value == null) {
                this.log.trace("Property {} not found in {}, using blank value", (Object)key, (Object)defaultProperties);
                value = "";
            }
        }
        return value;
    }

    private String getPropertyFrom(String properties, String key) {
        Properties props = new Properties();
        try {
            InputStream inputStream = Config.class.getResourceAsStream(properties);
            props.load(inputStream);
        }
        catch (IOException e) {
            this.log.trace("Property {} not found in {}", (Object)key, (Object)properties);
        }
        return props.getProperty(key);
    }

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != ConfigKey.class) continue;
            try {
                ((ConfigKey)field.get(this)).reset();
            }
            catch (Exception e) {
                this.log.warn("Exception resetting {}", (Object)field);
            }
        }
    }

    private String defaultOsName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (SystemUtils.IS_OS_WINDOWS) {
            osName = OperatingSystem.WIN.name();
        } else if (SystemUtils.IS_OS_LINUX) {
            osName = OperatingSystem.LINUX.name();
        } else if (SystemUtils.IS_OS_MAC) {
            osName = OperatingSystem.MAC.name();
        }
        return osName;
    }

    private String defaultArchitecture() {
        return "X" + System.getProperty("sun.arch.data.model");
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public boolean isExecutable(File file) {
        return this.resolve(this.os).equalsIgnoreCase("win") ? file.getName().toLowerCase().endsWith(".exe") : file.canExecute();
    }

    public String getProperties() {
        return this.resolve(this.properties);
    }

    public Config setProperties(String properties) {
        this.properties.setValue(properties);
        return this;
    }

    public String getTargetPath() {
        String resolved = this.resolve(this.targetPath);
        String path = null;
        if (resolved != null) {
            path = resolved;
            if (path.contains(HOME)) {
                path = path.replace(HOME, System.getProperty("user.home"));
            }
            if (path.equals(".")) {
                path = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
        }
        return path;
    }

    public Config setTargetPath(String value) {
        this.targetPath.setValue(value);
        return this;
    }

    public boolean isForceCache() {
        return this.resolve(this.forceCache);
    }

    public Config setForceCache(boolean value) {
        this.forceCache.setValue(value);
        return this;
    }

    public boolean isOverride() {
        return this.resolve(this.override);
    }

    public Config setOverride(boolean value) {
        this.override.setValue(value);
        return this;
    }

    public boolean isUseMirror() {
        return this.resolve(this.useMirror);
    }

    public Config setUseMirror(boolean value) {
        this.useMirror.setValue(value);
        return this;
    }

    public boolean isUseBetaVersions() {
        return this.resolve(this.useBetaVersions);
    }

    public Config setUseBetaVersions(boolean value) {
        this.useBetaVersions.setValue(value);
        return this;
    }

    public boolean isAvoidExport() {
        return this.resolve(this.avoidExport);
    }

    public Config setAvoidExport(boolean value) {
        this.avoidExport.setValue(value);
        return this;
    }

    public boolean isAvoidOutputTree() {
        return this.resolve(this.avoidOutputTree);
    }

    public Config setAvoidOutputTree(boolean value) {
        this.avoidOutputTree.setValue(value);
        return this;
    }

    public boolean isAvoidAutoVersion() {
        return this.resolve(this.avoidAutoVersion);
    }

    public Config setAvoidAutoVersion(boolean value) {
        this.avoidAutoVersion.setValue(value);
        return this;
    }

    public boolean isAvoidAutoReset() {
        return this.resolve(this.avoidAutoReset);
    }

    public Config setAvoidAutoReset(boolean value) {
        this.avoidAutoReset.setValue(value);
        return this;
    }

    public boolean isAvoidPreferences() {
        return this.resolve(this.avoidPreferences);
    }

    public Config setAvoidPreferences(boolean value) {
        this.avoidPreferences.setValue(value);
        return this;
    }

    public int getTimeout() {
        return this.resolve(this.timeout);
    }

    public Config setTimeout(int value) {
        this.timeout.setValue(value);
        return this;
    }

    public URL getVersionsPropertiesUrl() {
        return this.resolve(this.versionsPropertiesUrl);
    }

    public Config setVersionsPropertiesUrl(URL value) {
        this.versionsPropertiesUrl.setValue(value);
        return this;
    }

    public Architecture getArchitecture() {
        String architectureString = this.resolve(this.architecture);
        if ("32".equals(architectureString)) {
            return Architecture.X32;
        }
        if ("64".equals(architectureString)) {
            return Architecture.X64;
        }
        return Architecture.valueOf(architectureString);
    }

    public Config setArchitecture(Architecture value) {
        this.architecture.setValue(value.name());
        return this;
    }

    public String getOs() {
        return this.resolve(this.os);
    }

    public Config setOs(String value) {
        this.os.setValue(value);
        return this;
    }

    public String getProxy() {
        return this.resolve(this.proxy);
    }

    public Config setProxy(String value) {
        this.proxy.setValue(value);
        return this;
    }

    public String getProxyUser() {
        return this.resolve(this.proxyUser);
    }

    public Config setProxyUser(String value) {
        this.proxyUser.setValue(value);
        return this;
    }

    public String getProxyPass() {
        return this.resolve(this.proxyPass);
    }

    public Config setProxyPass(String value) {
        this.proxyPass.setValue(value);
        return this;
    }

    public String[] getIgnoreVersions() {
        String ignored = this.resolve(this.ignoreVersions);
        String[] out = new String[]{};
        if (!Config.isNullOrEmpty(ignored)) {
            out = ignored.split(",");
        }
        return out;
    }

    public Config setIgnoreVersions(String ... value) {
        this.ignoreVersions.setValue(String.join((CharSequence)",", value));
        return this;
    }

    public String getGitHubTokenName() {
        return this.resolve(this.gitHubTokenName);
    }

    public Config setGitHubTokenName(String value) {
        this.gitHubTokenName.setValue(value);
        return this;
    }

    public String getGitHubTokenSecret() {
        return this.resolve(this.gitHubTokenSecret);
    }

    public Config setGitHubTokenSecret(String value) {
        this.gitHubTokenSecret.setValue(value);
        return this;
    }

    public int getServerPort() {
        return this.resolve(this.serverPort);
    }

    public Config setServerPort(int value) {
        this.serverPort.setValue(value);
        return this;
    }

    public int getTtl() {
        return this.resolve(this.ttl);
    }

    public Config setTtl(int value) {
        this.ttl.setValue(value);
        return this;
    }

    public String getBinaryPath() {
        return this.resolve(this.binaryPath);
    }

    public Config setBinaryPath(String value) {
        this.binaryPath.setValue(value);
        return this;
    }

    public String getChromeDriverVersion() {
        return this.resolve(this.chromeDriverVersion);
    }

    public Config setChromeDriverVersion(String value) {
        this.chromeDriverVersion.setValue(value);
        return this;
    }

    public String getChromeDriverExport() {
        return this.resolve(this.chromeDriverExport);
    }

    public Config setChromeDriverExport(String value) {
        this.chromeDriverExport.setValue(value);
        return this;
    }

    public URL getChromeDriverUrl() {
        return this.resolve(this.chromeDriverUrl);
    }

    public Config setChromeDriverUrl(URL value) {
        this.chromeDriverUrl.setValue(value);
        return this;
    }

    public URL getChromeDriverMirrorUrl() {
        return this.resolve(this.chromeDriverMirrorUrl);
    }

    public Config setChromeDriverMirrorUrl(URL value) {
        this.chromeDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getEdgeDriverVersion() {
        return this.resolve(this.edgeDriverVersion);
    }

    public Config setEdgeDriverVersion(String value) {
        this.edgeDriverVersion.setValue(value);
        return this;
    }

    public String getEdgeDriverExport() {
        return this.resolve(this.edgeDriverExport);
    }

    public Config setEdgeDriverExport(String value) {
        this.edgeDriverExport.setValue(value);
        return this;
    }

    public URL getEdgeDriverUrl() {
        return this.resolve(this.edgeDriverUrl);
    }

    public Config setEdgeDriverUrl(URL value) {
        this.edgeDriverUrl.setValue(value);
        return this;
    }

    public String getFirefoxDriverVersion() {
        return this.resolve(this.firefoxDriverVersion);
    }

    public Config setFirefoxDriverVersion(String value) {
        this.firefoxDriverVersion.setValue(value);
        return this;
    }

    public String getFirefoxDriverExport() {
        return this.resolve(this.firefoxDriverExport);
    }

    public Config setFirefoxDriverExport(String value) {
        this.firefoxDriverExport.setValue(value);
        return this;
    }

    public URL getFirefoxDriverUrl() {
        return this.resolve(this.firefoxDriverUrl);
    }

    public Config setFirefoxDriverUrl(URL value) {
        this.firefoxDriverUrl.setValue(value);
        return this;
    }

    public URL getFirefoxDriverMirrorUrl() {
        return this.resolve(this.firefoxDriverMirrorUrl);
    }

    public Config setFirefoxDriverMirrorUrl(URL value) {
        this.firefoxDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getInternetExplorerDriverVersion() {
        return this.resolve(this.internetExplorerDriverVersion);
    }

    public Config setInternetExplorerDriverVersion(String value) {
        this.internetExplorerDriverVersion.setValue(value);
        return this;
    }

    public String getInternetExplorerDriverExport() {
        return this.resolve(this.internetExplorerDriverExport);
    }

    public Config setInternetExplorerDriverExport(String value) {
        this.internetExplorerDriverExport.setValue(value);
        return this;
    }

    public URL getInternetExplorerDriverUrl() {
        return this.resolve(this.internetExplorerDriverUrl);
    }

    public Config setInternetExplorerDriverUrl(URL value) {
        this.internetExplorerDriverUrl.setValue(value);
        return this;
    }

    public String getOperaDriverVersion() {
        return this.resolve(this.operaDriverVersion);
    }

    public Config setOperaDriverVersion(String value) {
        this.operaDriverVersion.setValue(value);
        return this;
    }

    public String getOperaDriverExport() {
        return this.resolve(this.operaDriverExport);
    }

    public Config setOperaDriverExport(String value) {
        this.operaDriverExport.setValue(value);
        return this;
    }

    public URL getOperaDriverUrl() {
        return this.resolve(this.operaDriverUrl);
    }

    public Config setOperaDriverUrl(URL value) {
        this.operaDriverUrl.setValue(value);
        return this;
    }

    public URL getOperaDriverMirrorUrl() {
        return this.resolve(this.operaDriverMirrorUrl);
    }

    public Config setOperaDriverMirrorUrl(URL value) {
        this.operaDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getPhantomjsDriverVersion() {
        return this.resolve(this.phantomjsDriverVersion);
    }

    public Config setPhantomjsDriverVersion(String value) {
        this.phantomjsDriverVersion.setValue(value);
        return this;
    }

    public String getPhantomjsDriverExport() {
        return this.resolve(this.phantomjsDriverExport);
    }

    public Config setPhantomjsDriverExport(String value) {
        this.phantomjsDriverExport.setValue(value);
        return this;
    }

    public URL getPhantomjsDriverUrl() {
        return this.resolve(this.phantomjsDriverUrl);
    }

    public Config setPhantomjsDriverUrl(URL value) {
        this.phantomjsDriverUrl.setValue(value);
        return this;
    }

    public URL getPhantomjsDriverMirrorUrl() {
        return this.resolve(this.phantomjsDriverMirrorUrl);
    }

    public Config setPhantomjsDriverMirrorUrl(URL value) {
        this.phantomjsDriverMirrorUrl.setValue(value);
        return this;
    }

    public String getSeleniumServerStandaloneVersion() {
        return this.resolve(this.seleniumServerStandaloneVersion);
    }

    public Config setSeleniumServerStandaloneVersion(String value) {
        this.seleniumServerStandaloneVersion.setValue(value);
        return this;
    }

    public URL getSeleniumServerStandaloneUrl() {
        return this.resolve(this.seleniumServerStandaloneUrl);
    }

    public Config setSeleniumServerStandaloneUrl(URL value) {
        this.seleniumServerStandaloneUrl.setValue(value);
        return this;
    }
}

