/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class ChromeDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.CHROME;
    }

    @Override
    protected String getDriverName() {
        return "chromedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getChromeDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getChromeDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getChromeDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getChromeDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setChromeDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setChromeDriverUrl(url);
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = this.getDriverUrl();
        List<URL> urls = this.isUsingTaobaoMirror() ? this.getDriversFromMirror(driverUrl) : this.getDriversFromXml(driverUrl);
        return urls;
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        return this.getDefaultBrowserVersion(this.getProgramFilesEnv(), "\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe", "google-chrome", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "--version", this.getDriverManagerType().toString());
    }
}

