/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.ConfigKey;
import io.github.bonigarcia.wdm.OperatingSystem;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String HOME = "~";
    ConfigKey<String> properties = new ConfigKey<String>("wdm.properties", String.class, "webdrivermanager.properties");
    ConfigKey<String> targetPath = new ConfigKey<String>("wdm.targetPath", String.class);
    ConfigKey<Boolean> forceCache = new ConfigKey<Boolean>("wdm.forceCache", Boolean.class);
    ConfigKey<Boolean> override = new ConfigKey<Boolean>("wdm.override", Boolean.class);
    ConfigKey<Boolean> useMirror = new ConfigKey<Boolean>("wdm.useMirror", Boolean.class);
    ConfigKey<Boolean> useBetaVersions = new ConfigKey<Boolean>("wdm.useBetaVersions", Boolean.class);
    ConfigKey<Boolean> avoidExport = new ConfigKey<Boolean>("wdm.avoidExport", Boolean.class);
    ConfigKey<Boolean> avoidOutputTree = new ConfigKey<Boolean>("wdm.avoidOutputTree", Boolean.class);
    ConfigKey<Boolean> avoidAutoVersion = new ConfigKey<Boolean>("wdm.avoidAutoVersion", Boolean.class);
    ConfigKey<Integer> timeout = new ConfigKey<Integer>("wdm.timeout", Integer.class);
    ConfigKey<String> architecture = new ConfigKey<String>("wdm.architecture", String.class, this.defaultArchitecture());
    ConfigKey<String> os = new ConfigKey<String>("wdm.os", String.class, this.defaultOsName());
    ConfigKey<String> proxy = new ConfigKey<String>("wdm.proxy", String.class);
    ConfigKey<String> proxyUser = new ConfigKey<String>("wdm.proxyUser", String.class);
    ConfigKey<String> proxyPass = new ConfigKey<String>("wdm.proxyPass", String.class);
    ConfigKey<String> ignoreVersions = new ConfigKey<String>("wdm.ignoreVersions", String.class);
    ConfigKey<String> gitHubTokenName = new ConfigKey<String>("wdm.gitHubTokenName", String.class);
    ConfigKey<String> gitHubTokenSecret = new ConfigKey<String>("wdm.gitHubTokenSecret", String.class);
    ConfigKey<String> driverVersion = new ConfigKey<String>(String.class);
    ConfigKey<URL> driverUrl = new ConfigKey<URL>(URL.class);
    ConfigKey<URL> driverMirrorUrl = new ConfigKey<URL>(URL.class);
    ConfigKey<String> driverExport = new ConfigKey<String>(String.class);
    ConfigKey<Integer> serverPort = new ConfigKey<Integer>("wdm.serverPort", Integer.class);

    private <T> T resolve(ConfigKey<T> configKey) {
        String name = configKey.getName();
        T tValue = configKey.getValue();
        Class<T> type = configKey.getType();
        return this.resolver(name, tValue, type);
    }

    private <T> T resolver(String name, T tValue, Class<T> type) {
        String strValue = System.getenv(name.toUpperCase().replace(".", "_"));
        if (strValue == null) {
            strValue = System.getProperty(name);
        }
        if (strValue == null && tValue != null) {
            return tValue;
        }
        if (strValue == null) {
            strValue = this.getProperty(name);
        }
        return this.parse(type, strValue);
    }

    private <T> T parse(Class<T> type, String strValue) {
        Object output = null;
        if (type.equals(String.class)) {
            output = strValue;
        } else if (type.equals(Integer.class)) {
            output = Integer.valueOf(strValue);
        } else if (type.equals(Boolean.class)) {
            output = Boolean.valueOf(strValue);
        } else if (type.equals(URL.class)) {
            try {
                output = new URL(strValue);
            }
            catch (Exception e) {
                throw new WebDriverManagerException(e);
            }
        } else {
            throw new WebDriverManagerException("Type " + type.getTypeName() + " cannot be parsed");
        }
        return (T)output;
    }

    private String getProperty(String key) {
        String value = null;
        Properties props = new Properties();
        try {
            InputStream inputStream = Config.class.getResourceAsStream("/" + this.getProperties());
            props.load(inputStream);
            value = props.getProperty(key);
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        finally {
            if (value == null) {
                this.log.trace("Property key {} not found, using default value", (Object)key);
                value = "";
            }
        }
        return value;
    }

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != ConfigKey.class) continue;
            try {
                ((ConfigKey)field.get(this)).reset();
            }
            catch (Exception e) {
                this.log.warn("Exception resetting {}", (Object)field);
            }
        }
    }

    private String defaultOsName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (SystemUtils.IS_OS_WINDOWS) {
            osName = OperatingSystem.WIN.name();
        } else if (SystemUtils.IS_OS_LINUX) {
            osName = OperatingSystem.LINUX.name();
        } else if (SystemUtils.IS_OS_MAC) {
            osName = OperatingSystem.MAC.name();
        }
        return osName;
    }

    private String defaultArchitecture() {
        return "X" + System.getProperty("sun.arch.data.model");
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public boolean isExecutable(File file) {
        return this.resolve(this.os).equalsIgnoreCase("win") ? file.getName().toLowerCase().endsWith(".exe") : file.canExecute();
    }

    public String getProperties() {
        return this.resolve(this.properties);
    }

    public Config setProperties(String properties) {
        this.properties.setValue(properties);
        return this;
    }

    public String getTargetPath() {
        String resolved = this.resolve(this.targetPath);
        String path = null;
        if (resolved != null) {
            path = resolved;
            if (path.contains(HOME)) {
                path = path.replace(HOME, System.getProperty("user.home"));
            }
            if (path.equals(".")) {
                path = Paths.get("", new String[0]).toAbsolutePath().toString();
            }
        }
        return path;
    }

    public Config setTargetPath(String value) {
        this.targetPath.setValue(value);
        return this;
    }

    public boolean isForceCache() {
        return this.resolve(this.forceCache);
    }

    public Config setForceCache(boolean value) {
        this.forceCache.setValue(value);
        return this;
    }

    public boolean isOverride() {
        return this.resolve(this.override);
    }

    public Config setOverride(boolean value) {
        this.override.setValue(value);
        return this;
    }

    public boolean isUseMirror() {
        return this.resolve(this.useMirror);
    }

    public Config setUseMirror(boolean value) {
        this.useMirror.setValue(value);
        return this;
    }

    public boolean isUseBetaVersions() {
        return this.resolve(this.useBetaVersions);
    }

    public Config setUseBetaVersions(boolean value) {
        this.useBetaVersions.setValue(value);
        return this;
    }

    public boolean isAvoidExport() {
        return this.resolve(this.avoidExport);
    }

    public Config setAvoidExport(boolean value) {
        this.avoidExport.setValue(value);
        return this;
    }

    public boolean isAvoidOutputTree() {
        return this.resolve(this.avoidOutputTree);
    }

    public Config setAvoidOutputTree(boolean value) {
        this.avoidOutputTree.setValue(value);
        return this;
    }

    public boolean isAvoidAutoVersion() {
        return this.resolve(this.avoidAutoVersion);
    }

    public Config setAvoidAutoVersion(boolean value) {
        this.avoidAutoVersion.setValue(value);
        return this;
    }

    public int getTimeout() {
        return this.resolve(this.timeout);
    }

    public Config setTimeout(int value) {
        this.timeout.setValue(value);
        return this;
    }

    public Architecture getArchitecture() {
        return Architecture.valueOf(this.resolve(this.architecture));
    }

    public Config setArchitecture(Architecture value) {
        this.architecture.setValue(value.name());
        return this;
    }

    public String getOs() {
        return this.resolve(this.os);
    }

    public Config setOs(String value) {
        this.os.setValue(value);
        return this;
    }

    public String getProxy() {
        return this.resolve(this.proxy);
    }

    public Config setProxy(String value) {
        this.proxy.setValue(value);
        return this;
    }

    public String getProxyUser() {
        return this.resolve(this.proxyUser);
    }

    public Config setProxyUser(String value) {
        this.proxyUser.setValue(value);
        return this;
    }

    public String getProxyPass() {
        return this.resolve(this.proxyPass);
    }

    public Config setProxyPass(String value) {
        this.proxyPass.setValue(value);
        return this;
    }

    public String[] getIgnoreVersions() {
        String ignored = this.resolve(this.ignoreVersions);
        String[] out = new String[]{};
        if (!Config.isNullOrEmpty(ignored)) {
            out = ignored.split(",");
        }
        return out;
    }

    public Config setIgnoreVersions(String ... value) {
        this.ignoreVersions.setValue(String.join((CharSequence)",", value));
        return this;
    }

    public String getGitHubTokenName() {
        return this.resolve(this.gitHubTokenName);
    }

    public Config setGitHubTokenName(String value) {
        this.gitHubTokenName.setValue(value);
        return this;
    }

    public String getGitHubTokenSecret() {
        return this.resolve(this.gitHubTokenSecret);
    }

    public Config setGitHubTokenSecret(String value) {
        this.gitHubTokenSecret.setValue(value);
        return this;
    }

    public String getDriverVersion(String name) {
        return this.resolver(name, this.driverVersion.getValue(), this.driverVersion.getType());
    }

    public Config setDriverVersion(String value) {
        this.driverVersion.setValue(value);
        return this;
    }

    public URL getDriverUrl(String name) {
        return this.resolver(name, this.driverUrl.getValue(), this.driverUrl.getType());
    }

    public Config setDriverUrl(URL value) {
        this.driverUrl.setValue(value);
        return this;
    }

    public URL getDriverMirrorUrl(String name) {
        return this.resolver(name, this.driverMirrorUrl.getValue(), this.driverMirrorUrl.getType());
    }

    public Config setDriverMirrorUrl(URL value) {
        this.driverMirrorUrl.setValue(value);
        return this;
    }

    public String getDriverExport(String name) {
        return this.resolver(name, this.driverExport.getValue(), this.driverExport.getType());
    }

    public Config setDriverExport(String value) {
        this.driverExport.setValue(value);
        return this;
    }

    public Boolean getUseMirror(String driverMirrorUrlKey) {
        if (Config.isNullOrEmpty(driverMirrorUrlKey)) {
            throw new WebDriverManagerException("Mirror URL not available");
        }
        return this.resolve(this.useMirror);
    }

    public int getServerPort() {
        return this.resolve(this.serverPort);
    }

    public Config setServerPort(int value) {
        this.serverPort.setValue(value);
        return this;
    }
}

