/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class ChromeDriverManager
extends WebDriverManager {
    protected ChromeDriverManager() {
        this.driverManagerType = DriverManagerType.CHROME;
        this.exportParameterKey = "wdm.chromeDriverExport";
        this.driverVersionKey = "wdm.chromeDriverVersion";
        this.driverUrlKey = "wdm.chromeDriverUrl";
        this.driverMirrorUrlKey = "wdm.chromeDriverMirrorUrl";
        this.driverName = "chromedriver";
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = ChromeDriverManager.config().getDriverUrl(this.driverUrlKey);
        List<URL> urls = this.isUsingTaobaoMirror() ? this.getDriversFromMirror(driverUrl) : this.getDriversFromXml(driverUrl);
        return urls;
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        return this.getDefaultBrowserVersion("PROGRAMFILES(X86)", "\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe", "google-chrome", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "--version", this.driverManagerType.toString());
    }
}

