/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class ChromeDriverManager
extends WebDriverManager {
    public static synchronized WebDriverManager getInstance() {
        return ChromeDriverManager.chromedriver();
    }

    public ChromeDriverManager() {
        this.driverManagerType = DriverManagerType.CHROME;
        this.exportParameter = WdmConfig.getString("wdm.chromeDriverExport");
        this.driverVersionKey = "wdm.chromeDriverVersion";
        this.driverUrlKey = "wdm.chromeDriverUrl";
        this.driverMirrorUrlKey = "wdm.chromeDriverMirrorUrl";
        this.driverName = Arrays.asList("chromedriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        URL driverUrl = this.getDriverUrl();
        List<URL> urls = this.isUsingTaobaoMirror() ? this.getDriversFromMirror(driverUrl) : this.getDriversFromXml(this.getDriverUrl());
        return urls;
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return super.getCurrentVersion(url, driverName);
    }
}

