/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WdmHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends BrowserManager {
    public static synchronized BrowserManager getInstance() {
        if (instance == null || !instance.getClass().equals(EdgeDriverManager.class)) {
            instance = new EdgeDriverManager();
        }
        return instance;
    }

    public EdgeDriverManager() {
        this.exportParameter = WdmConfig.getString("wdm.edgeExport");
        this.driverVersionKey = "wdm.edgeVersion";
        this.driverUrlKey = "wdm.edgeDriverUrl";
        this.driverName = Arrays.asList("MicrosoftWebDriver");
    }

    @Override
    public List<URL> getDrivers() throws IOException {
        this.listVersions = new ArrayList();
        ArrayList<URL> urlList = new ArrayList<URL>();
        String edgeDriverUrl = WdmConfig.getString("wdm.edgeDriverUrl");
        this.log.debug("Reading {} to find out the latest version of Edge driver", (Object)edgeDriverUrl);
        int timeout = (int)TimeUnit.SECONDS.toMillis(WdmConfig.getInt("wdm.timeout"));
        try (InputStream in = this.httpClient.execute(new WdmHttpClient.Get(edgeDriverUrl, timeout)).getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Elements downloadLink = doc.select("ul.driver-downloads li.driver-download > a");
            Elements versionParagraph = doc.select("ul.driver-downloads li.driver-download p.driver-download__meta");
            for (int i = 0; i < downloadLink.size(); ++i) {
                String[] version = ((Element)versionParagraph.get(i)).text().split(" ");
                this.listVersions.add(version[1]);
                urlList.add(new URL(((Element)downloadLink.get(i)).attr("href")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    @Override
    protected List<URL> getLatest(List<URL> list, List<String> match) {
        this.log.trace("Checking the lastest version of {} with URL list {}", match, list);
        ArrayList<URL> out = new ArrayList<URL>();
        this.versionToDownload = (String)this.listVersions.iterator().next();
        out.add(list.iterator().next());
        this.log.info("Latest version of MicrosoftWebDriver is {}", (Object)this.versionToDownload);
        return out;
    }
}

