/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperaDriverManager
extends BrowserManager {
    private static OperaDriverManager instance;

    public static synchronized OperaDriverManager getInstance() {
        if (instance == null) {
            instance = new OperaDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws IOException {
        URL driverUrl = this.getDriverUrl();
        String driverVersion = this.versionToDownload;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
        if (driverVersion != null) {
            releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (GitHubApi release : releaseArray) {
            if (release == null) continue;
            List<LinkedTreeMap<String, Object>> assets = release.getAssets();
            for (LinkedTreeMap<String, Object> asset : assets) {
                urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
            }
        }
        reader.close();
        return urls;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.operaDriverExport");
    }

    private GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            if (release.getName() == null || !release.getName().equalsIgnoreCase(version)) continue;
            out = release;
            break;
        }
        return out;
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("operadriver");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.operaDriverVersion");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.operaDriverUrl");
    }
}

