/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.common.io.Files;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    protected static final Logger log = LoggerFactory.getLogger(Downloader.class);
    private static final String HOME = "~";

    public static final synchronized void download(URL url, String version, String export, String driverName) throws IOException {
        boolean download;
        File targetFile = new File(Downloader.getTarget(version, url));
        File binary = null;
        boolean bl = download = !targetFile.getParentFile().exists() || WdmConfig.getBoolean("wdm.override");
        if (!download) {
            Collection listFiles = FileUtils.listFiles((File)targetFile.getParentFile(), null, (boolean)true);
            for (File file : listFiles) {
                if (file.getName().startsWith(driverName) && file.canExecute()) {
                    binary = file;
                    log.debug("Using binary driver previously downloaded {}", (Object)binary);
                    break;
                }
                download = true;
            }
        }
        if (download) {
            log.info("Downloading {} to {}", (Object)url, (Object)targetFile);
            FileUtils.copyURLToFile((URL)url, (File)targetFile);
            binary = export.contains("edge") ? Downloader.extractMsi(targetFile) : Downloader.unZip(targetFile);
            targetFile.delete();
        }
        if (export != null) {
            BrowserManager.exportDriver(export, binary.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File extractMsi(File msi) throws IOException {
        File tmpMsi = new File(Files.createTempDir().getAbsoluteFile() + File.separator + msi.getName());
        Files.move((File)msi, (File)tmpMsi);
        log.trace("Temporal msi file: {}", (Object)tmpMsi);
        Process process = Runtime.getRuntime().exec(new String[]{"msiexec", "/a", tmpMsi.toString(), "/qb", "TARGETDIR=" + msi.getParent()});
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            log.error("Exception waiting to msiexec to be finished", (Throwable)e);
        }
        finally {
            process.destroy();
        }
        tmpMsi.delete();
        Collection listFiles = FileUtils.listFiles((File)new File(msi.getParent()), (String[])new String[]{"exe"}, (boolean)true);
        return (File)listFiles.iterator().next();
    }

    public static final File unZip(File folder) throws IOException {
        ZipFile zipFolder = new ZipFile(folder);
        Enumeration<? extends ZipEntry> enu = zipFolder.entries();
        File file = null;
        while (enu.hasMoreElements()) {
            ZipEntry zipEntry = enu.nextElement();
            String name = zipEntry.getName();
            long size = zipEntry.getSize();
            long compressedSize = zipEntry.getCompressedSize();
            log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", new Object[]{name, size, compressedSize});
            file = new File(folder.getParentFile() + File.separator + name);
            if (!file.exists() || WdmConfig.getBoolean("wdm.override")) {
                int length;
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                InputStream is = zipFolder.getInputStream(zipEntry);
                FileOutputStream fos = new FileOutputStream(file);
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) >= 0) {
                    fos.write(bytes, 0, length);
                }
                is.close();
                fos.close();
                file.setExecutable(true);
                continue;
            }
            log.debug(file + " already exists");
        }
        zipFolder.close();
        return file.getAbsoluteFile();
    }

    private static final String getTarget(String version, URL url) throws IOException {
        String zip = url.getFile().substring(url.getFile().lastIndexOf("/"));
        int iFirst = zip.indexOf("_");
        int iLast = iFirst != zip.lastIndexOf("_") ? zip.lastIndexOf("_") : zip.length();
        String folder = zip.substring(0, iLast).replace(".zip", "").replace(".msi", "").replace("_", File.separator);
        return Downloader.getTargetPath() + folder + File.separator + version + File.separator + zip;
    }

    protected static String getTargetPath() {
        String targetPath = WdmConfig.getString("wdm.targetPath");
        if (targetPath.contains(HOME)) {
            targetPath = targetPath.replace(HOME, System.getProperty("user.home"));
        }
        return targetPath;
    }
}

