/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.utils.signaturegenerator;

import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public final class Ed25519SignatureGenerator
implements SignatureGenerator {
    private Ed25519PrivateKeyParameters privateKey;
    private final int offset = 0;

    public Ed25519SignatureGenerator(String privateKey) throws FileNotFoundException, IOException {
        ParameterChecker.checkParameterType(privateKey, String.class, "privateKey");
        Security.addProvider((Provider)new BouncyCastleProvider());
        PemReader pemReader = new PemReader((Reader)new FileReader(privateKey));
        PemObject pemObject = pemReader.readPemObject();
        byte[] privateKeyBytes = pemObject.getContent();
        this.privateKey = (Ed25519PrivateKeyParameters)PrivateKeyFactory.createKey((byte[])privateKeyBytes);
        pemReader.close();
    }

    @Override
    public String getSignature(String data) {
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        Ed25519Signer signer = new Ed25519Signer();
        signer.init(true, (CipherParameters)this.privateKey);
        signer.update(dataBytes, 0, dataBytes.length);
        byte[] signatureBytes = signer.generateSignature();
        return Base64.getEncoder().encodeToString(signatureBytes);
    }
}

