/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class SpotAlgo {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TWAP_ORDER = "/sapi/v1/algo/spot/newOrderTwap";
    private final String CANCEL_ORDER = "/sapi/v1/algo/spot/order";
    private final String OPEN_ORDERS = "/sapi/v1/algo/spot/openOrders";
    private final String HISTORICAL_ORDERS = "/sapi/v1/algo/spot/historicalOrders";
    private final String SUB_ORDERS = "/sapi/v1/algo/spot/subOrders";

    public SpotAlgo(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public SpotAlgo(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String twapOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "symbol", String.class);
        ParameterChecker.checkParameter(parameters, "side", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "quantity");
        ParameterChecker.checkParameter(parameters, "duration", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/algo/spot/newOrderTwap", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String cancelOrder(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algoId", Long.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/algo/spot/order", parameters, HttpMethod.DELETE, this.showLimitUsage);
    }

    public String getOpenOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/algo/spot/openOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getHistoricalOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/algo/spot/historicalOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getSubOrders(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "algoId", Long.class);
        return this.requestHandler.sendPublicRequest(this.baseUrl, "/sapi/v1/algo/spot/subOrders", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

