/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class NFT {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String TRANSACTIONS = "/sapi/v1/nft/history/transactions";
    private final String DEPOSIT = "/sapi/v1/nft/history/deposit";
    private final String WITHDRAW = "/sapi/v1/nft/history/withdraw";
    private final String GET_ASSET = "/sapi/v1/nft/user/getAsset";

    public NFT(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public NFT(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String transactionsHistory(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "orderType", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/nft/history/transactions", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String depositHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/nft/history/deposit", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String withdrawHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/nft/history/withdraw", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String getAsset(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/nft/user/getAsset", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

