/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class Blvt {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String BLVT_INFO = "/sapi/v1/blvt/tokenInfo";
    private final String SUBSCRIBE = "/sapi/v1/blvt/subscribe";
    private final String SUBSCRIPTION_RECORD = "/sapi/v1/blvt/subscribe/record";
    private final String REDEEM = "/sapi/v1/blvt/redeem";
    private final String REDEEM_RECORD = "/sapi/v1/blvt/redeem/record";
    private final String USER_LIMIT = "/sapi/v1/blvt/userLimit";

    public Blvt(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public Blvt(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String blvtInfo(Map<String, Object> parameters) {
        return this.requestHandler.sendApiRequest(this.baseUrl, "/sapi/v1/blvt/tokenInfo", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String subscribe(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "tokenName", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "cost");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/blvt/subscribe", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String subscriptionRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/blvt/subscribe/record", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String redeem(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "tokenName", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/blvt/redeem", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String redeemRecord(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/blvt/redeem/record", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String userLimit(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/blvt/userLimit", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

