/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl;

import com.binance.connector.client.WebSocketStreamClient;
import com.binance.connector.client.exceptions.BinanceConnectorException;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.RequestBuilder;
import com.binance.connector.client.utils.UrlBuilder;
import com.binance.connector.client.utils.WebSocketConnection;
import com.binance.connector.client.utils.httpclient.WebSocketStreamHttpClientSingleton;
import com.binance.connector.client.utils.websocketcallback.WebSocketClosedCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketClosingCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketFailureCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketMessageCallback;
import com.binance.connector.client.utils.websocketcallback.WebSocketOpenCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketStreamClientImpl
implements WebSocketStreamClient {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketStreamClientImpl.class);
    private static final OkHttpClient client = WebSocketStreamHttpClientSingleton.getHttpClient();
    private final String baseUrl;
    private final Map<Integer, WebSocketConnection> connections = new HashMap<Integer, WebSocketConnection>();
    private final WebSocketOpenCallback noopOpenCallback;
    private final WebSocketClosingCallback noopClosingCallback;
    private final WebSocketClosedCallback noopClosedCallback;
    private final WebSocketFailureCallback noopFailureCallback;

    public WebSocketStreamClientImpl() {
        this.noopOpenCallback = response -> {};
        this.noopClosingCallback = (code, reason) -> {};
        this.noopClosedCallback = (code, reason) -> {};
        this.noopFailureCallback = (throwable, response) -> {};
        this.baseUrl = "wss://stream.binance.com:9443";
    }

    public WebSocketStreamClientImpl(String baseUrl) {
        this.noopOpenCallback = response -> {};
        this.noopClosingCallback = (code, reason) -> {};
        this.noopClosedCallback = (code, reason) -> {};
        this.noopFailureCallback = (throwable, response) -> {};
        this.baseUrl = baseUrl;
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.aggTradeStream(symbol.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int aggTradeStream(String symbol, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@aggTrade", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int tradeStream(String symbol, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.tradeStream(symbol.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int tradeStream(String symbol, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@trade", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.klineStream(symbol.toLowerCase(), interval, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int klineStream(String symbol, String interval, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@kline_%s", this.baseUrl, symbol.toLowerCase(), interval));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.miniTickerStream(symbol.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int miniTickerStream(String symbol, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@miniTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int allMiniTickerStream(WebSocketMessageCallback callback) {
        return this.allMiniTickerStream(this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int allMiniTickerStream(WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/!miniTicker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.symbolTicker(symbol.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int symbolTicker(String symbol, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@ticker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int allTickerStream(WebSocketMessageCallback callback) {
        return this.allTickerStream(this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int allTickerStream(WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/!ticker@arr", this.baseUrl));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int rollingWindowTicker(String symbol, String windowSize, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(symbol, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize)) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize));
        }
        return this.rollingWindowTicker(symbol.toLowerCase(), windowSize, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int rollingWindowTicker(String symbol, String windowSize, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        ParameterChecker.checkParameterType(symbol, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize)) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize));
        }
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@ticker_%s", this.baseUrl, symbol.toLowerCase(), windowSize));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int allRollingWindowTicker(String windowSize, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(windowSize, String.class, "windowSize");
        ArrayList<String> allowedWindowSize = new ArrayList<String>(){
            {
                this.add("1h");
                this.add("4h");
            }
        };
        if (!allowedWindowSize.contains(windowSize.toLowerCase())) {
            throw new BinanceConnectorException(String.format("\"%s\" is not a valid window size.", windowSize.toLowerCase()));
        }
        return this.allRollingWindowTicker(windowSize.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int allRollingWindowTicker(String windowSize, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(windowSize, String.class, "windowSize");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/!ticker_%s@arr", this.baseUrl, windowSize.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int bookTicker(String symbol, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.bookTicker(symbol.toLowerCase(), this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int bookTicker(String symbol, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@bookTicker", this.baseUrl, symbol.toLowerCase()));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.partialDepthStream(symbol.toLowerCase(), levels, speed, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int partialDepthStream(String symbol, int levels, int speed, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@depth%s@%sms", this.baseUrl, symbol.toLowerCase(), levels, speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketMessageCallback callback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        return this.diffDepthStream(symbol.toLowerCase(), speed, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int diffDepthStream(String symbol, int speed, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        ParameterChecker.checkParameterType(symbol, String.class, "symbol");
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s@depth@%sms", this.baseUrl, symbol.toLowerCase(), speed));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketMessageCallback callback) {
        return this.listenUserStream(listenKey, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int listenUserStream(String listenKey, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebSocketRequest(String.format("%s/ws/%s", this.baseUrl, listenKey));
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketMessageCallback callback) {
        return this.combineStreams(streams, this.noopOpenCallback, callback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public int combineStreams(ArrayList<String> streams, WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        String url = UrlBuilder.buildStreamUrl(this.baseUrl, streams);
        Request request = RequestBuilder.buildWebSocketRequest(url);
        return this.createConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request);
    }

    @Override
    public void closeConnection(int connectionId) {
        if (this.connections.containsKey(connectionId)) {
            this.connections.get(connectionId).close();
            logger.info("Closing Connection ID {}", (Object)connectionId);
            this.connections.remove(connectionId);
        } else {
            logger.info("Connection ID {} does not exist!", (Object)connectionId);
        }
    }

    @Override
    public void closeAllConnections() {
        if (!this.connections.isEmpty()) {
            logger.info("Closing {} connections(s)", (Object)this.connections.size());
            Iterator<Map.Entry<Integer, WebSocketConnection>> iter = this.connections.entrySet().iterator();
            while (iter.hasNext()) {
                WebSocketConnection connection = iter.next().getValue();
                connection.close();
                iter.remove();
            }
        }
        if (this.connections.isEmpty()) {
            client.dispatcher().executorService().shutdown();
            logger.info("All connections are closed!");
        }
    }

    private int createConnection(WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback, Request request) {
        WebSocketConnection connection = new WebSocketConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request, client);
        connection.connect();
        int connectionId = connection.getConnectionId();
        this.connections.put(connectionId, connection);
        return connectionId;
    }
}

