/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.auth;

import com.binance.connector.client.common.Pair;
import com.binance.connector.client.common.auth.Authentication;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class BinanceBaseAuthentication
implements Authentication {
    private static final int DIFF_TILL_POSITION_INDEX = 1;

    public String joinQueryParameters(List<Pair> params) {
        return this.joinQueryParameters(new StringBuilder(), params).toString();
    }

    public StringBuilder joinQueryParameters(StringBuilder sb, List<Pair> params) {
        if (params != null && !params.isEmpty()) {
            for (Pair param : params) {
                String key = param.getName();
                String value = param.getValue();
                sb.append(key);
                sb.append("=");
                sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public String buildTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }
}

