/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.dtos;

import com.binance.connector.client.common.JSON;
import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SessionLogonResponseResult
extends BaseDTO {
    private static final int DIFF_TILL_POSITION_INDEX = 1;
    private static final int MAX_DECIMAL_DIGITS = 30;
    private static DecimalFormat df;
    public static final String SERIALIZED_NAME_API_KEY = "apiKey";
    @SerializedName(value="apiKey")
    @Nullable
    private String apiKey;
    public static final String SERIALIZED_NAME_AUTHORIZED_SINCE = "authorizedSince";
    @SerializedName(value="authorizedSince")
    @Nullable
    private Long authorizedSince;
    public static final String SERIALIZED_NAME_CONNECTED_SINCE = "connectedSince";
    @SerializedName(value="connectedSince")
    @Nullable
    private Long connectedSince;
    public static final String SERIALIZED_NAME_RETURN_RATE_LIMITS = "returnRateLimits";
    @SerializedName(value="returnRateLimits")
    @Nullable
    private Boolean returnRateLimits;
    public static final String SERIALIZED_NAME_SERVER_TIME = "serverTime";
    @SerializedName(value="serverTime")
    @Nullable
    private Long serverTime;
    public static final String SERIALIZED_NAME_USER_DATA_STREAM = "userDataStream";
    @SerializedName(value="userDataStream")
    @Nullable
    private Boolean userDataStream;
    private static final HashSet<String> openapiFields;
    private static final HashSet<String> openapiRequiredFields;

    public SessionLogonResponseResult apiKey(@Nullable String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    @Nullable
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public void setApiKey(@Nullable String apiKey) {
        this.apiKey = apiKey;
    }

    public SessionLogonResponseResult authorizedSince(@Nullable Long authorizedSince) {
        this.authorizedSince = authorizedSince;
        return this;
    }

    @Nullable
    public Long getAuthorizedSince() {
        return this.authorizedSince;
    }

    public void setAuthorizedSince(@Nullable Long authorizedSince) {
        this.authorizedSince = authorizedSince;
    }

    public SessionLogonResponseResult connectedSince(@Nullable Long connectedSince) {
        this.connectedSince = connectedSince;
        return this;
    }

    @Nullable
    public Long getConnectedSince() {
        return this.connectedSince;
    }

    public void setConnectedSince(@Nullable Long connectedSince) {
        this.connectedSince = connectedSince;
    }

    public SessionLogonResponseResult returnRateLimits(@Nullable Boolean returnRateLimits) {
        this.returnRateLimits = returnRateLimits;
        return this;
    }

    @Nullable
    public Boolean getReturnRateLimits() {
        return this.returnRateLimits;
    }

    public void setReturnRateLimits(@Nullable Boolean returnRateLimits) {
        this.returnRateLimits = returnRateLimits;
    }

    public SessionLogonResponseResult serverTime(@Nullable Long serverTime) {
        this.serverTime = serverTime;
        return this;
    }

    @Nullable
    public Long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(@Nullable Long serverTime) {
        this.serverTime = serverTime;
    }

    public SessionLogonResponseResult userDataStream(@Nullable Boolean userDataStream) {
        this.userDataStream = userDataStream;
        return this;
    }

    @Nullable
    public Boolean getUserDataStream() {
        return this.userDataStream;
    }

    public void setUserDataStream(@Nullable Boolean userDataStream) {
        this.userDataStream = userDataStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionLogonResponseResult sessionLogonResponseResult = (SessionLogonResponseResult)o;
        return Objects.equals(this.apiKey, sessionLogonResponseResult.apiKey) && Objects.equals(this.authorizedSince, sessionLogonResponseResult.authorizedSince) && Objects.equals(this.connectedSince, sessionLogonResponseResult.connectedSince) && Objects.equals(this.returnRateLimits, sessionLogonResponseResult.returnRateLimits) && Objects.equals(this.serverTime, sessionLogonResponseResult.serverTime) && Objects.equals(this.userDataStream, sessionLogonResponseResult.userDataStream);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.authorizedSince, this.connectedSince, this.returnRateLimits, this.serverTime, this.userDataStream);
    }

    @Override
    public String toString() {
        String sb = "class SessionLogonResponseResult {\n\t\tapiKey: " + this.toIndentedString(this.apiKey) + "\n\t\tauthorizedSince: " + this.toIndentedString(this.authorizedSince) + "\n\t\tconnectedSince: " + this.toIndentedString(this.connectedSince) + "\n\t\treturnRateLimits: " + this.toIndentedString(this.returnRateLimits) + "\n\t\tserverTime: " + this.toIndentedString(this.serverTime) + "\n\t\tuserDataStream: " + this.toIndentedString(this.userDataStream) + "\n}";
        return sb;
    }

    @Override
    public String toUrlQueryString() {
        Boolean userDataStreamValue;
        Long serverTimeValue;
        Boolean returnRateLimitsValue;
        Long connectedSinceValue;
        Long authorizedSinceValue;
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put(SERIALIZED_NAME_API_KEY, this.getApiKey());
        String apiKeyValue = this.getApiKey();
        if (apiKeyValue != null) {
            String apiKeyValueAsString = "";
            apiKeyValueAsString = apiKeyValue.toString();
            valMap.put(SERIALIZED_NAME_API_KEY, SessionLogonResponseResult.urlEncode(apiKeyValueAsString));
        }
        if ((authorizedSinceValue = this.getAuthorizedSince()) != null) {
            String authorizedSinceValueAsString = "";
            authorizedSinceValueAsString = ((Object)authorizedSinceValue).toString();
            valMap.put(SERIALIZED_NAME_AUTHORIZED_SINCE, SessionLogonResponseResult.urlEncode(authorizedSinceValueAsString));
        }
        if ((connectedSinceValue = this.getConnectedSince()) != null) {
            String connectedSinceValueAsString = "";
            connectedSinceValueAsString = ((Object)connectedSinceValue).toString();
            valMap.put(SERIALIZED_NAME_CONNECTED_SINCE, SessionLogonResponseResult.urlEncode(connectedSinceValueAsString));
        }
        if ((returnRateLimitsValue = this.getReturnRateLimits()) != null) {
            String returnRateLimitsValueAsString = "";
            returnRateLimitsValueAsString = ((Object)returnRateLimitsValue).toString();
            valMap.put(SERIALIZED_NAME_RETURN_RATE_LIMITS, SessionLogonResponseResult.urlEncode(returnRateLimitsValueAsString));
        }
        if ((serverTimeValue = this.getServerTime()) != null) {
            String serverTimeValueAsString = "";
            serverTimeValueAsString = ((Object)serverTimeValue).toString();
            valMap.put(SERIALIZED_NAME_SERVER_TIME, SessionLogonResponseResult.urlEncode(serverTimeValueAsString));
        }
        if ((userDataStreamValue = this.getUserDataStream()) != null) {
            String userDataStreamValueAsString = "";
            userDataStreamValueAsString = ((Object)userDataStreamValue).toString();
            valMap.put(SERIALIZED_NAME_USER_DATA_STREAM, SessionLogonResponseResult.urlEncode(userDataStreamValueAsString));
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&"));
    }

    public Map<String, Object> toMap() {
        Boolean userDataStreamValue;
        Long serverTimeValue;
        Boolean returnRateLimitsValue;
        Long connectedSinceValue;
        Long authorizedSinceValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put(SERIALIZED_NAME_API_KEY, this.getApiKey());
        String apiKeyValue = this.getApiKey();
        if (apiKeyValue != null) {
            valMap.put(SERIALIZED_NAME_API_KEY, apiKeyValue);
        }
        if ((authorizedSinceValue = this.getAuthorizedSince()) != null) {
            valMap.put(SERIALIZED_NAME_AUTHORIZED_SINCE, authorizedSinceValue);
        }
        if ((connectedSinceValue = this.getConnectedSince()) != null) {
            valMap.put(SERIALIZED_NAME_CONNECTED_SINCE, connectedSinceValue);
        }
        if ((returnRateLimitsValue = this.getReturnRateLimits()) != null) {
            valMap.put(SERIALIZED_NAME_RETURN_RATE_LIMITS, returnRateLimitsValue);
        }
        if ((serverTimeValue = this.getServerTime()) != null) {
            valMap.put(SERIALIZED_NAME_SERVER_TIME, serverTimeValue);
        }
        if ((userDataStreamValue = this.getUserDataStream()) != null) {
            valMap.put(SERIALIZED_NAME_USER_DATA_STREAM, userDataStreamValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SessionLogonResponseResult is not found in the empty JSON string", openapiRequiredFields));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SessionLogonResponseResult` properties. JSON: %s", entry.getKey(), jsonElement));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_KEY) != null && !jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_KEY).toString()));
        }
    }

    public static SessionLogonResponseResult fromJson(String jsonString) throws IOException {
        return (SessionLogonResponseResult)JSON.getGson().fromJson(jsonString, SessionLogonResponseResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    private static DecimalFormat getFormatter() {
        if (null == df) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
            df = new DecimalFormat("#,##0.###", symbols);
            df.setMaximumFractionDigits(30);
            df.setGroupingUsed(false);
        }
        return df;
    }

    static {
        openapiFields = new HashSet();
        openapiFields.add(SERIALIZED_NAME_API_KEY);
        openapiFields.add(SERIALIZED_NAME_AUTHORIZED_SINCE);
        openapiFields.add(SERIALIZED_NAME_CONNECTED_SINCE);
        openapiFields.add(SERIALIZED_NAME_RETURN_RATE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_SERVER_TIME);
        openapiFields.add(SERIALIZED_NAME_USER_DATA_STREAM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SessionLogonResponseResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SessionLogonResponseResult.class));
            return new TypeAdapter<SessionLogonResponseResult>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, SessionLogonResponseResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SessionLogonResponseResult read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (SessionLogonResponseResult)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

