/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.writer;

import io.github.biezhi.excel.plus.Writer;
import io.github.biezhi.excel.plus.annotation.ExcelColumn;
import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.conveter.ConverterCache;
import io.github.biezhi.excel.plus.conveter.DateConverter;
import io.github.biezhi.excel.plus.conveter.LocalDateConverter;
import io.github.biezhi.excel.plus.conveter.LocalDateTimeConverter;
import io.github.biezhi.excel.plus.conveter.NullConverter;
import io.github.biezhi.excel.plus.exception.WriterException;
import io.github.biezhi.excel.plus.util.StringUtil;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriter.class);
    private int rowNum;
    private Sheet sheet;
    private Map<Integer, Field> fieldIndexes;
    private List<ExcelColumn> columns;
    Workbook workbook;
    OutputStream outputStream;

    ExcelWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    ExcelWriter() {
    }

    void writeSheet(Writer writer) throws WriterException {
        this.sheet = this.workbook.createSheet(writer.sheetName());
        CellStyle headerStyle = null;
        CellStyle columnStyle = null;
        CellStyle titleStyle = null;
        if (null != writer.headerStyle()) {
            headerStyle = writer.headerStyle().accept(this.workbook, this.workbook.createCellStyle());
        }
        if (null != writer.cellStyle()) {
            columnStyle = writer.cellStyle().accept(this.workbook, this.workbook.createCellStyle());
        }
        if (null != writer.titleStyle()) {
            titleStyle = writer.titleStyle().accept(this.workbook, this.workbook.createCellStyle());
        }
        if (writer.isRaw()) {
            writer.sheetConsumer().accept(this.sheet);
        } else {
            Collection<?> rows = writer.rows();
            Field[] fields = rows.iterator().next().getClass().getDeclaredFields();
            this.fieldIndexes = new HashMap<Integer, Field>(fields.length);
            this.columns = new ArrayList<ExcelColumn>();
            for (Field field : fields) {
                ExcelColumn column = field.getAnnotation(ExcelColumn.class);
                if (null == column) continue;
                field.setAccessible(true);
                this.fieldIndexes.put(column.index(), field);
                this.columns.add(column);
            }
            int colRowIndex = 0;
            String title = writer.headerTitle();
            if (StringUtil.isNotEmpty(title)) {
                Integer maxColIndex = this.columns.stream().map(ExcelColumn::index).max(Comparator.comparingInt(Integer::intValue)).get();
                this.writeHeader(titleStyle, this.sheet, title, maxColIndex);
                colRowIndex = 1;
            }
            this.rowNum = writer.startRow();
            if (this.rowNum == 0) {
                this.rowNum = colRowIndex + 1;
            }
            try {
                this.writeColumnNames(colRowIndex, headerStyle);
                for (Object row : rows) {
                    this.writeRow(row, columnStyle);
                }
            }
            catch (Exception e) {
                log.error("write row fail", (Throwable)e);
            }
        }
        try (OutputStream os = this.outputStream;){
            this.workbook.write(os);
        }
        catch (Exception e) {
            throw new WriterException("workbook write to OutputStream error", e);
        }
    }

    private void writeHeader(CellStyle cellStyle, Sheet sheet, String title, int maxColIndex) {
        Row titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(50.0f);
        for (int i = 0; i <= maxColIndex; ++i) {
            Cell cell = titleRow.createCell(i);
            if (i == 0) {
                cell.setCellValue(title);
            }
            if (null == cellStyle) continue;
            cell.setCellStyle(cellStyle);
        }
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, maxColIndex));
    }

    private void writeColumnNames(int rowIndex, CellStyle headerStyle) {
        Row rowHead = this.sheet.createRow(rowIndex);
        for (ExcelColumn column : this.columns) {
            Cell cell = rowHead.createCell(column.index());
            if (null != headerStyle) {
                cell.setCellStyle(headerStyle);
            }
            cell.setCellValue(column.title());
            if (column.width() > 0) {
                this.sheet.setColumnWidth(column.index(), column.width());
                continue;
            }
            this.sheet.setColumnWidth(column.index(), 5120);
        }
    }

    private void writeRow(Object instance, CellStyle columnStyle) throws Exception {
        Row row = this.sheet.createRow(this.rowNum++);
        for (Integer index : this.fieldIndexes.keySet()) {
            Object value;
            Field field = this.fieldIndexes.get(index);
            if (null == field || (value = field.get(instance)) == null) continue;
            Cell cell = row.createCell(index.intValue());
            if (null != columnStyle) {
                cell.setCellStyle(columnStyle);
            }
            String fieldValue = this.computeColumnContent(value, field);
            cell.setCellValue(fieldValue);
        }
    }

    String computeColumnContent(Object value, Field field) throws Exception {
        if (field.getType().equals(String.class)) {
            return value.toString();
        }
        ExcelColumn column = field.getAnnotation(ExcelColumn.class);
        if (!NullConverter.class.equals(column.converter())) {
            Converter convert = column.converter().newInstance();
            ConverterCache.addConvert(convert);
            return convert.toString(value);
        }
        if (StringUtil.isNotEmpty(column.datePattern())) {
            String content = "";
            if (Date.class.equals(field.getType())) {
                content = new DateConverter(column.datePattern()).toString((Date)value);
            } else if (LocalDate.class.equals(field.getType())) {
                content = new LocalDateConverter(column.datePattern()).toString((LocalDate)value);
            }
            if (LocalDateTime.class.equals(field.getType())) {
                content = new LocalDateTimeConverter(column.datePattern()).toString((LocalDateTime)value);
            }
            return content;
        }
        Converter converter = ConverterCache.computeConvert(field);
        if (null != converter) {
            return converter.toString(value);
        }
        return value.toString();
    }
}

