/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.types;

import io.github.biezhi.excel.plus.types.RowPredicate;
import io.github.biezhi.excel.plus.types.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Result<T> {
    private AtomicInteger atomicSuccess = new AtomicInteger(0);
    private AtomicInteger atomicError = new AtomicInteger(0);
    private Map<Integer, String> errorMap = new TreeMap<Integer, String>();
    private List<T> rows;
    private List<T> successRows;
    private List<T> errorRows;

    public Result(List<T> rows) {
        this.rows = rows;
        this.successRows = new ArrayList<T>(rows.size());
        this.errorRows = new ArrayList<T>();
    }

    public Result<T> valid(RowPredicate<Integer, T> rowPredicate) {
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            Valid valid = rowPredicate.test(i + 1, this.rows.get(i));
            if (null == valid) continue;
            if (valid.isSuccess()) {
                this.successRows.add(this.rows.get(i));
                this.atomicSuccess.incrementAndGet();
                continue;
            }
            this.atomicError.incrementAndGet();
            this.errorRows.add(this.rows.get(i));
            this.errorMap.put(i + 1, valid.msg());
        }
        return this;
    }

    public boolean isValid() {
        return Integer.valueOf(this.rows.size()).equals(this.atomicSuccess.get());
    }

    public int count() {
        return this.rows.size();
    }

    public int successCount() {
        return this.atomicSuccess.get();
    }

    public int errorCount() {
        return this.atomicError.get();
    }

    public List<T> rows() {
        return this.rows;
    }

    public List<T> successRows() {
        return this.successRows;
    }

    public List<T> errorRows() {
        return this.errorRows;
    }

    public List<String> errorMessages() {
        return new ArrayList<String>(this.errorMap.values());
    }

    public Map<Integer, String> errorMap() {
        return this.errorMap;
    }
}

