/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.Reader;
import io.github.biezhi.excel.plus.annotation.ExcelColumn;
import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.exception.ReaderException;
import io.github.biezhi.excel.plus.reader.ExcelReader;
import io.github.biezhi.excel.plus.reader.ReaderConverter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderWithCSV
extends ReaderConverter
implements ExcelReader {
    private static final Logger log = LoggerFactory.getLogger(ReaderWithCSV.class);
    private InputStream inputStream;

    public ReaderWithCSV(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Stream<T> readExcel(Reader reader) throws ReaderException {
        Class type = reader.modelType();
        try {
            this.initFieldConverter(type.getDeclaredFields());
        }
        catch (Exception e) {
            throw new ReaderException(e);
        }
        Stream.Builder builder = Stream.builder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, reader.charset()));){
            int startRow = reader.startRow();
            int pos = 0;
            String line = "";
            while ((line = br.readLine()) != null) {
                if (pos++ < startRow) continue;
                Object instance = type.newInstance();
                String[] csvLine = line.split(",");
                this.csvLineToInstance(instance, csvLine);
                builder.add(instance);
            }
            Stream stream = builder.build();
            return stream;
        }
        catch (Exception e) {
            throw new ReaderException(e);
        }
    }

    private void csvLineToInstance(Object instance, String[] csvLine) {
        for (Field field : this.fieldIndexes.values()) {
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            try {
                if (csvLine.length < column.index() + 1) continue;
                String cellValue = csvLine[column.index()];
                Converter converter = (Converter)this.fieldConverters.get(field);
                if (null != converter) {
                    cellValue = converter.stringToR(csvLine[column.index()]);
                }
                field.set(instance, cellValue);
            }
            catch (Exception e) {
                log.error("write value {} to field {} failed", new Object[]{csvLine[column.index()], field.getName(), e});
            }
        }
    }
}

