/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.Reader;
import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.exception.ConverterException;
import io.github.biezhi.excel.plus.exception.ReaderException;
import io.github.biezhi.excel.plus.reader.ExcelReader;
import io.github.biezhi.excel.plus.reader.ReaderConverter;
import io.github.biezhi.excel.plus.util.StringUtil;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderWith2003
extends ReaderConverter
implements ExcelReader {
    private static final Logger log = LoggerFactory.getLogger(ReaderWith2003.class);
    private Workbook workbook;

    public ReaderWith2003(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public <T> Stream<T> readExcel(Reader reader) throws ReaderException {
        Class type = reader.modelType();
        Stream.Builder builder = Stream.builder();
        try {
            this.initFieldConverter(type.getDeclaredFields());
            Sheet sheet = this.getSheet(reader);
            int startRow = reader.startRow();
            int totalRow = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < totalRow; ++i) {
                Row row;
                if (i < startRow || null == (row = sheet.getRow(i))) continue;
                Object instance = type.newInstance();
                for (Field field : this.fieldIndexes.values()) {
                    this.writeFiledValue(row, instance, field);
                }
                builder.add(instance);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ReaderException(e);
        }
    }

    public Sheet getSheet(Reader reader) {
        return StringUtil.isNotEmpty(reader.sheetName()) ? this.workbook.getSheet(reader.sheetName()) : this.workbook.getSheetAt(reader.sheetIndex());
    }

    @Override
    public Object getCellValue(Field field, Cell cell) throws ConverterException {
        Converter converter = (Converter)this.fieldConverters.get(field);
        if (null == converter) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() != CellType.NUMERIC) {
            return converter.stringToR(cell.getStringCellValue());
        }
        if (this.isDateType(field.getType())) {
            Date javaDate = DateUtil.getJavaDate((double)cell.getNumericCellValue());
            if (field.getType().equals(Date.class)) {
                return javaDate;
            }
            if (field.getType().equals(LocalDate.class)) {
                return javaDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            if (field.getType().equals(LocalDateTime.class)) {
                return javaDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            return null;
        }
        return converter.stringToR(cell.getNumericCellValue() + "");
    }

    private boolean isDateType(Class<?> type) {
        return Date.class.equals(type) || LocalDate.class.equals(type) || LocalDateTime.class.equals(type);
    }
}

