/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.Reader;
import io.github.biezhi.excel.plus.exception.ReaderException;
import io.github.biezhi.excel.plus.reader.ReaderWith2003;
import io.github.biezhi.excel.plus.reader.ReaderWith2007;
import io.github.biezhi.excel.plus.reader.ReaderWithCSV;
import io.github.biezhi.excel.plus.util.ExcelUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReaderFactory {
    private static final Logger log = LoggerFactory.getLogger(ReaderFactory.class);

    public static <T> Stream<T> readByFile(Reader reader) {
        if (ExcelUtil.isXLSX(reader.fromFile())) {
            return new ReaderWith2007(null).readExcel(reader);
        }
        if (ExcelUtil.isCSV(reader.fromFile())) {
            try {
                return new ReaderWithCSV(new FileInputStream(reader.fromFile())).readExcel(reader);
            }
            catch (FileNotFoundException e) {
                throw new ReaderException(reader.fromFile().getName() + " not found", e);
            }
        }
        if (ExcelUtil.isXLS(reader.fromFile())) {
            return new ReaderWith2003(ExcelUtil.create(reader.fromFile())).readExcel(reader);
        }
        throw new ReaderException(reader.fromFile().getName() + " is the wrong format");
    }

    public static <T> Stream<T> readByStream(Reader reader) throws ReaderException {
        byte[] bytes;
        try {
            bytes = ExcelUtil.streamAsBytes(reader.fromStream());
        }
        catch (IOException e) {
            throw new ReaderException(e);
        }
        if (ExcelUtil.isXLSX(new ByteArrayInputStream(bytes))) {
            reader.from(new ByteArrayInputStream(bytes));
            return new ReaderWith2007(null).readExcel(reader);
        }
        if (ExcelUtil.isXLS(new ByteArrayInputStream(bytes))) {
            return new ReaderWith2003(ExcelUtil.create(new ByteArrayInputStream(bytes))).readExcel(reader);
        }
        return new ReaderWithCSV(new ByteArrayInputStream(bytes)).readExcel(reader);
    }

    private ReaderFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

