/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus.reader;

import io.github.biezhi.excel.plus.annotation.ExcelColumn;
import io.github.biezhi.excel.plus.conveter.Converter;
import io.github.biezhi.excel.plus.conveter.ConverterCache;
import io.github.biezhi.excel.plus.conveter.NullConverter;
import io.github.biezhi.excel.plus.exception.ConverterException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderConverter {
    private static final Logger log = LoggerFactory.getLogger(ReaderConverter.class);
    Map<Integer, Field> fieldIndexes;
    Map<Field, Converter<String, ?>> fieldConverters;

    void initFieldConverter(Field[] fields) throws Exception {
        this.fieldConverters = new HashMap();
        this.fieldIndexes = new HashMap<Integer, Field>(fields.length);
        for (Field field : fields) {
            ExcelColumn column = field.getAnnotation(ExcelColumn.class);
            if (null == column) continue;
            field.setAccessible(true);
            this.fieldIndexes.put(column.index(), field);
            Converter converter = NullConverter.class.equals(column.converter()) ? ConverterCache.computeConvert(field) : column.converter().newInstance();
            if (null == converter) continue;
            this.fieldConverters.put(field, converter);
        }
    }

    void writeFiledValue(Row row, Object instance, Field field) {
        ExcelColumn column = field.getAnnotation(ExcelColumn.class);
        Cell cell = row.getCell(column.index());
        if (null == cell) {
            return;
        }
        try {
            Object cellValue = this.getCellValue(field, cell);
            field.set(instance, cellValue);
        }
        catch (Exception e) {
            log.error("write value {} to field {} failed", new Object[]{cell.getStringCellValue(), field.getName(), e});
        }
    }

    public Object getCellValue(Field field, Cell cell) throws ConverterException {
        return cell.getStringCellValue();
    }
}

