/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.excel.plus;

import io.github.biezhi.excel.plus.exception.ReaderException;
import io.github.biezhi.excel.plus.reader.ReaderFactory;
import io.github.biezhi.excel.plus.types.Result;
import io.github.biezhi.excel.plus.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Reader<T> {
    private Class<T> modelType;
    private int sheetIndex;
    private String sheetName;
    private int startRow = 2;
    private File fromFile;
    private InputStream fromStream;
    private Charset charset = StandardCharsets.UTF_8;

    public Reader(Class<T> modelType) {
        this.modelType = modelType;
    }

    public static <T> Reader<T> create(Class<T> modelType) {
        return new Reader<T>(modelType);
    }

    public static <T> Reader<T> create(Class<T> modelType, File fromFile) {
        return new Reader<T>(modelType).from(fromFile);
    }

    public static <T> Reader<T> create(Class<T> modelType, InputStream fromStream) {
        return new Reader<T>(modelType).from(fromStream);
    }

    public Reader<T> from(File fromFile) {
        if (null == fromFile || !fromFile.exists()) {
            throw new IllegalArgumentException("excel file must be exist");
        }
        this.fromFile = fromFile;
        return this;
    }

    public Reader<T> from(InputStream fromStream) {
        this.fromStream = fromStream;
        return this;
    }

    public Reader<T> start(int startRow) {
        if (startRow < 0) {
            throw new IllegalArgumentException("start cannot be less than 0");
        }
        this.startRow = startRow;
        return this;
    }

    public Reader<T> sheet(int sheetIndex) {
        if (sheetIndex < 0) {
            throw new IllegalArgumentException("sheet cannot be less than 0");
        }
        this.sheetIndex = sheetIndex;
        return this;
    }

    public Reader<T> sheet(String sheetName) {
        if (StringUtil.isEmpty(sheetName)) {
            throw new IllegalArgumentException("sheet cannot be empty");
        }
        this.sheetName = sheetName;
        return this;
    }

    public Reader<T> charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Stream<T> asStream() {
        if (this.modelType == null) {
            throw new IllegalArgumentException("modelType can be not null");
        }
        if (this.fromFile == null && this.fromStream == null) {
            throw new IllegalArgumentException("Excel source not is null");
        }
        if (this.fromFile != null) {
            return ReaderFactory.readByFile(this);
        }
        return ReaderFactory.readByStream(this);
    }

    public List<T> asList() throws ReaderException {
        Stream stream = this.asStream();
        return stream.collect(Collectors.toList());
    }

    public Result<T> asResult() throws ReaderException {
        return new Result<T>(this.asList());
    }

    public InputStream fromStream() {
        return this.fromStream;
    }

    public File fromFile() {
        return this.fromFile;
    }

    public Class<T> modelType() {
        return this.modelType;
    }

    public int sheetIndex() {
        return this.sheetIndex;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public int startRow() {
        return this.startRow;
    }

    public Charset charset() {
        return this.charset;
    }
}

