/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.timer;

import com.jn.langx.util.Objs;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.timing.timer.HashedWheelTimeout;
import com.jn.langx.util.timing.timer.HashedWheelTimer;
import com.jn.langx.util.timing.timer.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class DistinctHashedWheelTimeout
extends HashedWheelTimeout {
    private static final ConcurrentHashMap<HashedWheelTimer, ConcurrentHashMap<DistinctHashedWheelTimeout, Integer>> RUNNING_TASKS = new ConcurrentHashMap();

    public DistinctHashedWheelTimeout(HashedWheelTimer timer, TimerTask task, long deadline) {
        super(timer, task, deadline);
    }

    @Override
    public void executeTask() {
        HashedWheelTimer hashedWheelTimer = (HashedWheelTimer)this.timer;
        ConcurrentHashMap<DistinctHashedWheelTimeout, Integer> currentTimerRunningTasks = RUNNING_TASKS.get(hashedWheelTimer);
        if (currentTimerRunningTasks == null) {
            RUNNING_TASKS.putIfAbsent(hashedWheelTimer, new ConcurrentHashMap());
            currentTimerRunningTasks = RUNNING_TASKS.get(hashedWheelTimer);
        }
        if (!currentTimerRunningTasks.containsKey(this)) {
            super.executeTask();
        }
    }

    @Override
    public void run() {
        block4: {
            try {
                HashedWheelTimer hashedWheelTimer = (HashedWheelTimer)this.timer;
                ConcurrentHashMap<DistinctHashedWheelTimeout, Integer> currentTimerRunningTasks = RUNNING_TASKS.get(hashedWheelTimer);
                if (currentTimerRunningTasks == null) {
                    RUNNING_TASKS.putIfAbsent(hashedWheelTimer, new ConcurrentHashMap());
                    currentTimerRunningTasks = RUNNING_TASKS.get(hashedWheelTimer);
                }
                if (!currentTimerRunningTasks.containsKey(this)) {
                    currentTimerRunningTasks.put(this, 1);
                    this.task.run(this);
                    currentTimerRunningTasks.remove(this);
                }
            }
            catch (Throwable t) {
                Logger logger = Loggers.getLogger(HashedWheelTimer.class);
                if (!logger.isWarnEnabled()) break block4;
                logger.warn("An exception was thrown by " + TimerTask.class.getSimpleName() + '.', t);
            }
        }
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DistinctHashedWheelTimeout)) {
            return false;
        }
        DistinctHashedWheelTimeout that = (DistinctHashedWheelTimeout)obj;
        if (this == that) {
            return true;
        }
        if (that.timer != this.timer) {
            return false;
        }
        return Objs.equals(this.task, that.task);
    }

    public final int hashCode() {
        return this.task.hashCode();
    }
}

