/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.timing.scheduling;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.ErrorHandler;
import com.jn.langx.exception.ErrorHandlers;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.concurrent.CommonThreadFactory;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.timing.scheduling.ImmediateTrigger;
import com.jn.langx.util.timing.scheduling.ReschedulingRunnable;
import com.jn.langx.util.timing.scheduling.Trigger;
import com.jn.langx.util.timing.timer.ReschedulingTask;
import com.jn.langx.util.timing.timer.RunnableToTimerTaskAdapter;
import com.jn.langx.util.timing.timer.Timeout;
import com.jn.langx.util.timing.timer.TimerTask;
import com.jn.langx.util.timing.timer.immediate.ImmediateTimer;
import com.jn.langx.util.timing.timer.javatimer.JavaTimer;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class ScheduledExecutors {
    private static int schedulerCoreSize = SystemPropertys.getAccessor().getInteger("langx.global.schedulerCoreSize", Platform.cpuCore() * 2);
    private static String schedulerThreadPrefix = SystemPropertys.getAccessor().getString("langx.global.schedulerThreadPrefix", "GLOBAL_SCHEDULER");
    private static ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(schedulerCoreSize, new CommonThreadFactory(schedulerThreadPrefix, true));

    public static ScheduledExecutorService getScheduledExecutor() {
        return scheduledExecutorService;
    }

    public static ScheduledFuture scheduleTask(@NonNull Runnable task) {
        return ScheduledExecutors.scheduleTask(task, null, null);
    }

    public static ScheduledFuture scheduleTask(@NonNull Runnable task, @NonNull ErrorHandler errorHandler) {
        return ScheduledExecutors.scheduleTask(task, null, errorHandler);
    }

    public static ScheduledFuture scheduleTask(@NonNull Runnable task, @Nullable Trigger trigger, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.scheduleTask(ScheduledExecutors.getScheduledExecutor(), task, trigger, errorHandler);
    }

    public static ScheduledFuture scheduleTask(ScheduledExecutorService scheduledExecutorService, @NonNull Runnable task, @Nullable Trigger trigger, @Nullable ErrorHandler errorHandler) {
        Preconditions.checkNotNull(task);
        if (errorHandler == null) {
            errorHandler = ErrorHandlers.getIgnoreErrorHandler();
        }
        if (trigger == null) {
            trigger = ImmediateTrigger.INSTANCE;
        }
        ReschedulingRunnable taskWrapper = new ReschedulingRunnable(scheduledExecutorService, task, trigger, errorHandler);
        taskWrapper.schedule();
        return taskWrapper;
    }

    public static Timeout timeoutTask(@NonNull com.jn.langx.util.timing.timer.Timer timer, @NonNull Runnable task, @Nullable Trigger trigger, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.timeoutTask(timer, new RunnableToTimerTaskAdapter(Preconditions.checkNotNull(task, "task is required")), trigger, errorHandler);
    }

    public static Timeout timeoutTask(@NonNull com.jn.langx.util.timing.timer.Timer timer, @NonNull TimerTask task, @Nullable Trigger trigger, @Nullable ErrorHandler errorHandler) {
        Preconditions.checkNotNull(task);
        if (errorHandler == null) {
            errorHandler = ErrorHandlers.getIgnoreErrorHandler();
        }
        if (trigger == null) {
            trigger = ImmediateTrigger.INSTANCE;
        }
        ReschedulingTask taskWrapper = new ReschedulingTask(timer, task, trigger, errorHandler);
        taskWrapper.schedule();
        return taskWrapper;
    }

    public static Timeout javaTimeoutTask(Timer timer, Executor taskExecutor, Runnable task, Trigger trigger, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.timeoutTask((com.jn.langx.util.timing.timer.Timer)new JavaTimer(timer, taskExecutor), task, trigger, errorHandler);
    }

    public static Timeout javaTimeoutTask(Timer timer, Executor taskExecutor, TimerTask task, Trigger trigger, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.timeoutTask((com.jn.langx.util.timing.timer.Timer)new JavaTimer(timer, taskExecutor), task, trigger, errorHandler);
    }

    public static Timeout immediateTask(ImmediateTimer timer, TimerTask task, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.timeoutTask((com.jn.langx.util.timing.timer.Timer)timer, task, (Trigger)ImmediateTrigger.INSTANCE, errorHandler);
    }

    public static Timeout immediateTask(Executor executor, TimerTask task, @Nullable ErrorHandler errorHandler) {
        return ScheduledExecutors.immediateTask(new ImmediateTimer(executor), task, errorHandler);
    }
}

