/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.MultiKeyMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.os.Platform;
import com.jn.langx.util.regexp.Option;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.RegexpEngine;
import com.jn.langx.util.regexp.RegexpMatcher;
import com.jn.langx.util.regexp.jdk.JdkRegexpEngine;
import com.jn.langx.util.regexp.named.Jdk6NamedRegexpEngine;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;

public class Regexps {
    private static MultiKeyMap<Regexp> cache = new MultiKeyMap();
    private static final GenericRegistry<RegexpEngine> registry = new GenericRegistry();

    private Regexps() {
    }

    public static Regexp compile(@NonNull String pattern) {
        return Regexps.createRegexp(pattern);
    }

    public static Regexp createRegexp(@NonNull String pattern) {
        return Regexps.createRegexp(pattern, (Option)null);
    }

    public static Regexp createRegexp(@NonNull Pattern pattern) {
        return Regexps.createRegexp((String)null, pattern.pattern(), Option.buildOption(pattern.flags()));
    }

    public static Regexp createRegexp(@NonNull String pattern, String flags) {
        return Regexps.createRegexp(pattern, Option.fromJavaScriptFlags(flags));
    }

    public static Regexp createRegexp(@NonNull String pattern, int flags) {
        return Regexps.createRegexp(pattern, Option.buildOption(flags));
    }

    public static Regexp createRegexp(@NonNull String pattern, @Nullable Option option) {
        return Regexps.createRegexp((String)null, pattern, option);
    }

    public static Regexp createRegexp(@Nullable String engineName, @NonNull String pattern, @Nullable Option option) {
        RegexpEngine engine;
        RegexpEngine regexpEngine = engine = engineName == null ? null : (RegexpEngine)registry.get(engineName);
        if (engine == null && engineName != null) {
            throw new RuntimeException(StringTemplates.formatWithPlaceholder("not found regexp engine {}", engineName));
        }
        return Regexps.createRegexp(engine, pattern, option);
    }

    public static Regexp createRegexp(@Nullable RegexpEngine engine, @NonNull String pattern, @Nullable Option option) {
        Regexp regexp;
        Preconditions.checkNotNull(pattern);
        if (option == null) {
            option = Option.DEFAULT;
        }
        if (engine == null) {
            engine = (RegexpEngine)registry.get("joni");
        }
        if (engine == null) {
            engine = (RegexpEngine)registry.get("jdk");
        }
        if ((regexp = cache.get(pattern, option, engine.getName())) == null) {
            regexp = engine.get(pattern, option);
            cache.put(pattern, option, engine.getName(), regexp);
        }
        return regexp;
    }

    public static boolean contains(String text, Regexp regexp) {
        RegexpMatcher matcher = regexp.matcher(text);
        return matcher.find();
    }

    public static boolean match(Regexp regexp, String text) {
        RegexpMatcher matcher = regexp.matcher(text);
        return matcher.matches();
    }

    public static boolean match(String regexp, int flags, String text) {
        return Regexps.match(Regexps.createRegexp(regexp, flags), text);
    }

    public static boolean match(String regexp, String text) {
        return Regexps.match(Regexps.createRegexp(regexp), text);
    }

    public static List<Map<String, String>> findNamedGroups(Regexp regexp, String text) {
        RegexpMatcher matcher = regexp.matcher(text);
        return matcher.namedGroups();
    }

    public static Map<String, String> findNamedGroup(Regexp regexp, String text) {
        List<Map<String, String>> groupsList = Regexps.findNamedGroups(regexp, text);
        if (Objs.isNotEmpty(groupsList)) {
            return groupsList.get(0);
        }
        return null;
    }

    public static Map<String, String> namedGroups(RegexpMatcher matcher, Set<String> groupNames) {
        LinkedHashMap<String, String> namedGroups = new LinkedHashMap<String, String>();
        for (String groupName : groupNames) {
            String groupValue = matcher.group(groupName);
            namedGroups.put(groupName, groupValue);
        }
        return namedGroups;
    }

    static {
        if (Platform.JAVA_VERSION_INT < 7) {
            registry.register(new Jdk6NamedRegexpEngine());
        } else {
            registry.register(new JdkRegexpEngine());
        }
        Collects.forEach(ServiceLoader.load(RegexpEngine.class), new Consumer<RegexpEngine>(){

            @Override
            public void accept(RegexpEngine regexpFactory) {
                registry.register(regexpFactory);
            }
        });
        registry.init();
    }
}

