/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pattern.patternset;

import com.jn.langx.Factory;
import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.exception.ExpressionParseException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.pattern.patternset.PatternSet;
import com.jn.langx.util.pattern.patternset.PatternSetExpressionParser;
import java.util.List;

public class GenericPatternSetExpressionParser<PatternEntry extends Named>
implements PatternSetExpressionParser<PatternEntry> {
    @NonNull
    private Factory<String, PatternEntry> patternFactory;

    public GenericPatternSetExpressionParser(Factory<String, PatternEntry> patternFactory) {
        this.setPatternFactory(patternFactory);
    }

    @Override
    public PatternSet<PatternEntry> parse(String expression) {
        Preconditions.checkNotEmpty(expression, "the expression is empty or null");
        Preconditions.checkNotEmpty(this.getSeparator(), "the separator is empty or null");
        Preconditions.checkNotNull(this.patternFactory, "the pattern factory is null");
        List<String> segments = Collects.asList(Strings.split(expression, this.getSeparator(), false));
        PatternSet<PatternEntry> patternSet = this.internalParse(segments);
        patternSet.setExcludeFlag(this.getExcludeFlag());
        patternSet.setSeparator(this.getSeparator());
        patternSet.setExpression(expression);
        return patternSet;
    }

    protected PatternSet<PatternEntry> internalParse(List<String> segments) throws ExpressionParseException {
        final PatternSet patternSet = new PatternSet();
        Collects.forEach(segments, new Consumer<String>(){

            @Override
            public void accept(String segment) {
                if (Strings.startsWith(segment, GenericPatternSetExpressionParser.this.getExcludeFlag())) {
                    patternSet.addExclude((Named)GenericPatternSetExpressionParser.this.patternFactory.get(segment));
                } else {
                    patternSet.addInclude((Named)GenericPatternSetExpressionParser.this.patternFactory.get(segment));
                }
            }
        });
        return patternSet;
    }

    @Override
    public String getSeparator() {
        return ";";
    }

    @Override
    public String getExcludeFlag() {
        return "!";
    }

    public Factory<String, PatternEntry> getPatternFactory() {
        return this.patternFactory;
    }

    public void setPatternFactory(Factory<String, PatternEntry> patternFactory) {
        this.patternFactory = patternFactory;
    }
}

