/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.pattern.patternset;

import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.pattern.AbstractPatternMatcher;
import com.jn.langx.util.pattern.patternset.PatternSet;
import com.jn.langx.util.pattern.patternset.PatternSetExpressionParser;

public abstract class AbstractPatternSetMatcher<PatternEntry extends Named>
extends AbstractPatternMatcher {
    @Nullable
    private PatternSet<PatternEntry> defaultPatternSet;
    @Nullable
    private PatternSetExpressionParser<PatternEntry> expressionParser;
    @Nullable
    private PatternSet<PatternEntry> patternSet;

    public AbstractPatternSetMatcher(@Nullable PatternSetExpressionParser<PatternEntry> expressionParser, @Nullable String defaultPatternExpression) {
        this.setExpressionParser(expressionParser);
        this.setDefaultExpression(defaultPatternExpression);
    }

    public AbstractPatternSetMatcher(@NonNull PatternSetExpressionParser<PatternEntry> expressionParser, @Nullable PatternSet<PatternEntry> defaultPatternSet) {
        this.setExpressionParser(expressionParser);
        this.setDefaultPatternSet(defaultPatternSet);
    }

    public AbstractPatternSetMatcher(@NonNull PatternSetExpressionParser<PatternEntry> expressionParser, @Nullable PatternSet<PatternEntry> defaultPatternSet, PatternSet<PatternEntry> patternSet) {
        this.setExpressionParser(expressionParser);
        this.setDefaultPatternSet(defaultPatternSet);
        this.setPatternSet(patternSet);
    }

    public AbstractPatternSetMatcher(@NonNull PatternSetExpressionParser<PatternEntry> expressionParser, @Nullable String defaultPatternSet, String patternSetExpression) {
        this.setExpressionParser(expressionParser);
        this.setDefaultExpression(defaultPatternSet);
        this.setPatternExpression(patternSetExpression);
    }

    public void setExpressionParser(PatternSetExpressionParser<PatternEntry> expressionParser) {
        Preconditions.checkNotNull(expressionParser);
        this.expressionParser = expressionParser;
    }

    public PatternSet<PatternEntry> getDefaultPatternSet() {
        return this.defaultPatternSet;
    }

    public void setDefaultPatternSet(@Nullable PatternSet<PatternEntry> defaultPatternSet) {
        this.defaultPatternSet = defaultPatternSet;
    }

    public void setDefaultExpression(@Nullable String defaultExpression) {
        if (Strings.isNotEmpty(defaultExpression)) {
            Preconditions.checkNotNull(this.expressionParser, "the expression parser is null");
            this.setDefaultPatternSet(this.expressionParser.parse(defaultExpression));
        }
    }

    public void setPatternSet(PatternSet<PatternEntry> patternSet) {
        this.patternSet = patternSet;
    }

    @Override
    public void setPatternExpression(@Nullable String expression) {
        if (Strings.isNotEmpty(expression)) {
            Preconditions.checkNotNull(this.expressionParser, "the expression parser is null");
            this.setPatternSet(this.expressionParser.parse(expression));
        }
    }

    @Override
    public Boolean matches(final String string) {
        PatternSet<PatternEntry> patternSet = this.defaultPatternSet;
        if (Emptys.isNotEmpty(this.patternSet)) {
            patternSet = this.patternSet;
        }
        if (Emptys.isEmpty(patternSet)) {
            throw new IllegalStateException("has no any pattern");
        }
        boolean matched = Collects.anyMatch(this.patternSet.getIncludes(), new Predicate<PatternEntry>(){

            @Override
            public boolean test(PatternEntry patternEntry) {
                return AbstractPatternSetMatcher.this.doMatch(patternEntry.getName(), string, AbstractPatternSetMatcher.this.option.isGlobal());
            }
        });
        if (matched) {
            matched = Collects.noneMatch(this.patternSet.getExcludes(), new Predicate<PatternEntry>(){

                @Override
                public boolean test(PatternEntry patternEntry) {
                    return AbstractPatternSetMatcher.this.doMatch(patternEntry.getName(), string, AbstractPatternSetMatcher.this.option.isGlobal());
                }
            });
        }
        return matched;
    }

    protected abstract boolean doMatch(String var1, String var2, boolean var3);
}

